/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction.CustomFuncParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import java.math.BigDecimal;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AvgParser
implements CustomFuncParser {
    private static final Logger log = LoggerFactory.getLogger(AvgParser.class);

    @Override
    public boolean accept(String type) {
        return MechanismEnum.FunctionType.AVG.getCode().equalsIgnoreCase(type);
    }

    @Override
    public String getOutPutTypeByName(String dataType) {
        return MechanismEnum.FunctionType.AVG.getOutputType();
    }

    @Override
    public BigDecimal parse(MechanismVariable mechanismVariable, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return null;
        }
        String dataName = mechanismVariable.getData_name();
        BigDecimal avgValue = metaDataList.stream().map(v -> {
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString((Object)v));
            BigDecimal sourceValue = null;
            try {
                sourceValue = metaDataObj.getBigDecimal(dataName);
            }
            catch (Exception e) {
                log.warn("AvgParser.parse \u8868\u683c\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0c\u6570\u636e\u4e3a\uff1a{}", v);
            }
            return sourceValue;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        return avgValue.divide(BigDecimal.valueOf(metaDataList.size()));
    }
}

