/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType.FieldValueTypeParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DateParser
implements FieldValueTypeParser {
    private static final Logger log = LoggerFactory.getLogger(DateParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String dataType) {
        return MechanismEnum.FieldValueType.DATE.getCode().equalsIgnoreCase(dataType);
    }

    @Override
    public JSONArray parse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        JSONArray result = new JSONArray();
        CustomFuncResult rightCondResult = this.mechanismParserFactory.getRightCondParserByType(conditionConfig.getRightCondType()).preParse(conditionConfig, metaDataList);
        if (!rightCondResult.getIsNeedNextJudge().booleanValue()) {
            return rightCondResult.getMetaDataList();
        }
        String opType = conditionConfig.getOpType();
        Date rightToDate = null;
        Date rightFromDate = null;
        try {
            MechanismVariable rightTo = conditionConfig.getRight().getTo();
            Object rightToValueObj = rightTo.getValue();
            String currentDateType = conditionConfig.getRight().getType();
            if (rightToValueObj.toString().matches("^[1-9][0-9]{3}.[0-9]{1,2}.[0-9]{1,2}.*$")) {
                rightToDate = this.convertStringToDate(rightToValueObj.toString());
            } else {
                Integer rightToOffsetValue = Integer.valueOf(rightToValueObj.toString().split("[/.]")[0]);
                rightToDate = this.getOffsetDate(currentDateType, rightToOffsetValue);
            }
            if (opType.equals(MechanismEnum.OperateType.BETWEEN.getCode())) {
                MechanismVariable rightFrom = conditionConfig.getRight().getFrom();
                Object rightFromValueObj = rightFrom.getValue();
                if (rightFromValueObj.toString().matches("^[1-9][0-9]{3}.[0-9]{1,2}.[0-9]{1,2}.*$")) {
                    rightFromDate = this.convertStringToDate(rightToValueObj.toString());
                } else {
                    Integer rightToOffsetValue = Integer.valueOf(rightFromValueObj.toString().split("[/.]")[0]);
                    rightFromDate = this.getOffsetDate(currentDateType, rightToOffsetValue);
                }
            }
        }
        catch (Exception e) {
            log.error("DateParser.parse \u53f3\u4fa7\u6761\u4ef6\u5224\u65ad\u503c\u8f6c\u6362\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)conditionConfig);
            return result;
        }
        String dataName = conditionConfig.getLeft().getData_name();
        result.addAll((Collection)this.execCondition(opType, dataName, rightFromDate, rightToDate, metaDataList));
        return result;
    }

    private JSONArray execCondition(String opType, String dataName, Date rightFromValue, Date rightToValue, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return new JSONArray();
        }
        List resultList = metaDataList.stream().filter(v -> {
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString((Object)v));
            String sourceValue = null;
            try {
                sourceValue = metaDataObj.getString(dataName);
            }
            catch (Exception e) {
                log.warn("NumericParser.parse \u8868\u683c\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0c\u6570\u636e\u4e3a\uff1a{}", v);
            }
            return this.isSatisfyCond(opType, sourceValue, rightFromValue, rightToValue);
        }).collect(Collectors.toList());
        return JSONArray.parseArray((String)JSON.toJSONString(resultList));
    }

    private Boolean isSatisfyCond(String opType, String sourceValue, Date rightFromDate, Date rightToDate) {
        Date sourceDate = this.convertStringToDate(sourceValue);
        if (sourceDate == null) {
            return Boolean.FALSE;
        }
        int toResult = sourceDate.compareTo(rightToDate);
        switch (opType) {
            case "eq": {
                return toResult == 0;
            }
            case "gt": {
                return toResult == 1;
            }
            case "lt": {
                return toResult == -1;
            }
            case "gte": {
                return toResult == 1 || toResult == 0;
            }
            case "lte": {
                return toResult == -1 || toResult == 0;
            }
            case "between": {
                int fromResult = sourceDate.compareTo(rightFromDate);
                return !(fromResult != 1 && fromResult != 0 || toResult != -1 && toResult != 0);
            }
        }
        return Boolean.FALSE;
    }

    private Date convertStringToDate(String sourceValue) {
        Date sourceDate;
        if (ObjectUtils.isEmpty((Object)sourceValue)) {
            return null;
        }
        if (!sourceValue.matches("^[1-9][0-9]{3}.[0-9]{1,2}.[0-9]{1,2}.*$")) {
            return null;
        }
        if (sourceValue.matches("[\\d]+")) {
            if (sourceValue.length() < 8) {
                return null;
            }
            try {
                sourceDate = DateUtils.parseDate((String)sourceValue.substring(0, 8), (String[])new String[]{"yyyyMMdd"});
            }
            catch (ParseException e) {
                log.error("DateParser.isSatisfyCond \u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff0c\u8868\u683c\u6570\u636e\u4e3a{}", (Object)sourceValue);
                return null;
            }
        } else {
            String[] split = sourceValue.split("[^\\d]");
            LocalDate sourceLocalDate = LocalDate.of(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            sourceDate = Date.from(sourceLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        return sourceDate;
    }

    private Date getOffsetDate(String currentDateType, Integer offsetValue) {
        switch (currentDateType) {
            case "current_day": {
                DateTime currentDay = DateUtil.beginOfDay((Date)DateUtil.date());
                return DateUtils.addDays((Date)new Date(currentDay.getTime()), (int)offsetValue);
            }
        }
        return null;
    }

    @Override
    public Boolean isBothEqual(Object source, Object targetLeft, Object targetRight, String opType) {
        return Boolean.FALSE;
    }
}

