/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType.FieldValueTypeParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DateTimeParser
implements FieldValueTypeParser {
    private static final Logger log = LoggerFactory.getLogger(DateTimeParser.class);

    @Override
    public boolean accept(String dataType) {
        return MechanismEnum.FieldValueType.DATETIME.getCode().equalsIgnoreCase(dataType);
    }

    @Override
    public JSONArray parse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        Object rightToValueObj = conditionConfig.getRight().getTo().getValue();
        String currentDateType = conditionConfig.getRight().getType();
        Integer rightToOffsetValue = Integer.valueOf(rightToValueObj.toString().split("[/.]")[0]);
        LocalDateTime rightToDate = this.getOffsetDate(currentDateType, rightToOffsetValue);
        LocalDateTime rightFromDate = null;
        if (conditionConfig.getOpType().equals(MechanismEnum.OperateType.BETWEEN.getCode())) {
            Object rightFromValueObj = conditionConfig.getRight().getFrom().getValue();
            Integer rightFromOffsetValue = Integer.valueOf(rightFromValueObj.toString().split("[/.]")[0]);
            rightFromDate = this.getOffsetDate(currentDateType, rightFromOffsetValue);
        }
        String dataName = conditionConfig.getLeft().getData_name();
        String opType = conditionConfig.getOpType();
        return this.doFilter(metaDataList, dataName, opType, rightToDate, rightFromDate);
    }

    private JSONArray doFilter(JSONArray metaDataList, String dataName, String opType, LocalDateTime rightToDate, LocalDateTime rightFromDate) {
        if (metaDataList == null || metaDataList.isEmpty()) {
            return new JSONArray();
        }
        JSONArray result = new JSONArray();
        for (Object each : metaDataList) {
            LocalDateTime source;
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString(each));
            Optional<LocalDateTime> sourceDateTime = this.parseToLocalDateTime(metaDataObj.getString(dataName));
            if (!sourceDateTime.isPresent() || !this.isMatch(source = sourceDateTime.get(), rightToDate, rightFromDate, opType)) continue;
            result.add((Object)metaDataObj);
        }
        return result;
    }

    private boolean isMatch(LocalDateTime source, LocalDateTime rightToDate, LocalDateTime rightFromDate, String opType) {
        int toResult = source.compareTo(rightToDate);
        switch (opType) {
            case "eq": {
                return toResult == 0;
            }
            case "gt": {
                return toResult > 0;
            }
            case "lt": {
                return toResult < 0;
            }
            case "gte": {
                return toResult >= 0;
            }
            case "lte": {
                return toResult <= 0;
            }
            case "between": {
                int fromResult = source.compareTo(rightFromDate);
                return fromResult >= 0 && toResult <= 0;
            }
        }
        return Boolean.FALSE;
    }

    private Optional<LocalDateTime> parseToLocalDateTime(String source) {
        if (null == source || source.isEmpty()) {
            return Optional.empty();
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd[' 'HH:mm:ss]")).appendOptional(DateTimeFormatter.ofPattern("yyyy/MM/dd[' 'HH:mm:ss]")).appendOptional(DateTimeFormatter.ofPattern("dd/MM/yyyy[' 'HH:mm:ss]")).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
        return Optional.of(LocalDateTime.parse(source, formatter));
    }

    private LocalDateTime getOffsetDate(String currentDateType, Integer rightToOffsetValue) {
        if (currentDateType.equals("currentDay")) {
            return LocalDateTime.now().plusDays(rightToOffsetValue.intValue());
        }
        return LocalDateTime.now();
    }

    @Override
    public Boolean isBothEqual(Object source, Object targetLeft, Object targetRight, String opType) {
        return Boolean.FALSE;
    }
}

