/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType.FieldValueTypeParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class NumericParser
implements FieldValueTypeParser {
    private static final Logger log = LoggerFactory.getLogger(NumericParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String dataType) {
        return MechanismEnum.FieldValueType.NUMERIC.getCode().equalsIgnoreCase(dataType);
    }

    @Override
    public JSONArray parse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        BigDecimal rightToValue;
        CustomFuncResult rightCondResult = this.mechanismParserFactory.getRightCondParserByType(conditionConfig.getRightCondType()).preParse(conditionConfig, metaDataList);
        if (!rightCondResult.getIsNeedNextJudge().booleanValue()) {
            return rightCondResult.getMetaDataList();
        }
        String opType = conditionConfig.getOpType();
        if (MechanismEnum.ConditionType.HIGH_GRADE.getCode().equalsIgnoreCase(conditionConfig.getType())) {
            return this.parseHighGrade(opType, conditionConfig, metaDataList);
        }
        JSONArray result = new JSONArray();
        BigDecimal rightFromValue = null;
        try {
            MechanismVariable rightTo = conditionConfig.getRight().getTo();
            Object rightToValueObj = rightTo.getValue();
            rightToValue = new BigDecimal(rightToValueObj.toString());
            if (opType.equals(MechanismEnum.OperateType.BETWEEN.getCode())) {
                MechanismVariable rightFrom = conditionConfig.getRight().getFrom();
                Object rightFromValueObj = rightFrom.getValue();
                rightFromValue = new BigDecimal(rightFromValueObj.toString());
            }
        }
        catch (Exception e) {
            log.error("NumericParser.parse \u53f3\u4fa7\u6761\u4ef6\u5224\u65ad\u503c\u8f6c\u6362\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)conditionConfig);
            return result;
        }
        String dataName = conditionConfig.getLeft().getData_name();
        result.addAll((Collection)this.parsePrimary(opType, dataName, rightFromValue, rightToValue, metaDataList));
        return result;
    }

    private JSONArray parseHighGrade(String opType, MechanismConditionConfig config, JSONArray metaDataList) {
        JSONArray resultArray = new JSONArray();
        Object functionValue = config.getLeft().getFunctionValue();
        try {
            Object fromValue = config.getRight().getFrom().getFunctionValue();
            Object toValue = config.getRight().getTo().getFunctionValue();
            BigDecimal sourceValue = new BigDecimal(functionValue.toString());
            Boolean satisfyCond = this.isSatisfyCond(opType, sourceValue, fromValue == null ? null : new BigDecimal(fromValue.toString()), new BigDecimal(toValue.toString()));
            if (satisfyCond.booleanValue()) {
                resultArray.addAll((Collection)metaDataList);
                return resultArray;
            }
        }
        catch (Exception e) {
            log.error("NumericParser.parse \u53f3\u4fa7\u6761\u4ef6\u5224\u65ad\u503c\u8f6c\u6362\u5931\u8d25\uff0c\u5165\u53c2config\uff1a{}", (Object)config);
            return null;
        }
        return null;
    }

    private JSONArray parsePrimary(String opType, String dataName, BigDecimal rightFromValue, BigDecimal rightToValue, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return new JSONArray();
        }
        List resultList = metaDataList.stream().filter(v -> {
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString((Object)v));
            BigDecimal sourceValue = null;
            try {
                sourceValue = metaDataObj.getBigDecimal(dataName);
            }
            catch (Exception e) {
                log.warn("NumericParser.parse \u8868\u683c\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0c\u6570\u636e\u4e3a\uff1a{}", v);
            }
            return this.isSatisfyCond(opType, sourceValue, rightFromValue, rightToValue);
        }).collect(Collectors.toList());
        return JSONArray.parseArray((String)JSON.toJSONString(resultList));
    }

    public Boolean isSatisfyCond(String opType, BigDecimal sourceValue, BigDecimal rightFromValue, BigDecimal rightToValue) {
        log.info("NumericParser.isSatisfyCond beginning...\u5165\u53c2\uff1a{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{opType, sourceValue, rightFromValue, rightToValue});
        if (sourceValue == null) {
            return Boolean.FALSE;
        }
        int toResult = sourceValue.compareTo(rightToValue);
        switch (opType) {
            case "eq": {
                return toResult == 0;
            }
            case "gt": {
                return toResult == 1;
            }
            case "lt": {
                return toResult == -1;
            }
            case "gte": {
                return toResult == 1 || toResult == 0;
            }
            case "lte": {
                return toResult == -1 || toResult == 0;
            }
            case "between": {
                int fromResult = sourceValue.compareTo(rightFromValue);
                return !(fromResult != 1 && fromResult != 0 || toResult != -1 && toResult != 0);
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isBothEqual(Object source, Object targetLeft, Object targetRight, String opType) {
        try {
            if (ObjectUtils.isEmpty((Object)targetRight) || ObjectUtils.isEmpty((Object)source) || ObjectUtils.isEmpty((Object)opType)) {
                return Boolean.FALSE;
            }
            BigDecimal sourceNum = new BigDecimal(source.toString());
            BigDecimal targetLeftNum = null;
            BigDecimal targetRightNum = new BigDecimal(targetRight.toString());
            if (!ObjectUtils.isEmpty((Object)targetLeft)) {
                targetLeftNum = new BigDecimal(targetLeft.toString());
            }
            return this.isSatisfyCond(opType, sourceNum, targetLeftNum, targetRightNum);
        }
        catch (Exception e) {
            log.error("NumericParser.isBothEqual \u5931\u8d25\uff0ce={}", (Throwable)e);
            return Boolean.FALSE;
        }
    }
}

