/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType.FieldValueTypeParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class StringParser
implements FieldValueTypeParser {
    private static final Logger log = LoggerFactory.getLogger(StringParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String dataType) {
        return MechanismEnum.FieldValueType.STRING.getCode().equalsIgnoreCase(dataType);
    }

    @Override
    public JSONArray parse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        CustomFuncResult rightCondResult = this.mechanismParserFactory.getRightCondParserByType(conditionConfig.getRightCondType()).preParse(conditionConfig, metaDataList);
        if (!rightCondResult.getIsNeedNextJudge().booleanValue()) {
            return rightCondResult.getMetaDataList();
        }
        if (MechanismEnum.ConditionType.HIGH_GRADE.getCode().equalsIgnoreCase(conditionConfig.getType())) {
            return this.parseHighGrade(conditionConfig, metaDataList);
        }
        return this.parsePrimary(conditionConfig, metaDataList);
    }

    private JSONArray parsePrimary(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        String rightToValue;
        JSONArray result = new JSONArray();
        try {
            MechanismVariable rightTo = conditionConfig.getRight().getTo();
            rightToValue = rightTo.getValue().toString();
        }
        catch (Exception e) {
            log.error("StringParser.parse \u53f3\u4fa7\u6761\u4ef6\u5224\u65ad\u503c\u8f6c\u6362\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)conditionConfig);
            return result;
        }
        String dataName = conditionConfig.getLeft().getData_name();
        List resultList = metaDataList.stream().filter(v -> {
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString((Object)v));
            String sourceValue = null;
            try {
                sourceValue = metaDataObj.getString(dataName);
            }
            catch (Exception e) {
                log.warn("StringParser.parse \u8868\u683c\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff0c\u6570\u636e\u4e3a\uff1a{}", v);
                return Boolean.FALSE;
            }
            return rightToValue.equalsIgnoreCase(sourceValue);
        }).collect(Collectors.toList());
        return JSONArray.parseArray((String)JSON.toJSONString(resultList));
    }

    private JSONArray parseHighGrade(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        JSONArray resultArray = new JSONArray();
        String functionValueType = conditionConfig.getLeft().getFunctionValueType();
        Object functionValue = conditionConfig.getLeft().getFunctionValue();
        Object value = conditionConfig.getRight().getTo().getFunctionValue();
        if (MechanismEnum.FieldValueType.NUMERIC.getCode().equalsIgnoreCase(functionValueType)) {
            try {
                BigDecimal functionValueTemp = new BigDecimal(functionValue.toString());
                BigDecimal valueTemp = new BigDecimal(value.toString());
                if (functionValueTemp.compareTo(valueTemp) == 0) {
                    resultArray.addAll((Collection)metaDataList);
                    return resultArray;
                }
            }
            catch (Exception e) {
                log.error("StringParser.compareCondition \u5931\u8d25\uff0ce={}", (Throwable)e);
                return null;
            }
            return null;
        }
        if (ObjectUtils.nullSafeEquals((Object)functionValue.toString(), (Object)value.toString())) {
            resultArray.addAll((Collection)metaDataList);
            return resultArray;
        }
        return null;
    }

    @Override
    public Boolean isBothEqual(Object source, Object targetLeft, Object targetRight, String opType) {
        try {
            String sourceStr = source.toString();
            String targetRightStr = targetRight.toString();
            return StringUtils.equalsIgnoreCase((CharSequence)sourceStr, (CharSequence)targetRightStr);
        }
        catch (Exception e) {
            log.error("StringParser.isBothEqual \u5931\u8d25\uff0ce={}", (Throwable)e);
            return Boolean.FALSE;
        }
    }
}

