/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.hooks;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.parsers.hooks.HooksParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.plan.LimitTaskActionPlan;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class CheckValidParser
implements HooksParser {
    @Override
    public boolean accept(MechanismConditionConfig config) {
        return MechanismEnum.ComponentType.CHECK_VALID.getCode().equalsIgnoreCase(config.getMetaFieldType());
    }

    @Override
    public HooksInfo parse(MechanismConditionConfig config, BindingContext context, PageView pageView, Map<String, Object> parameters) throws DWBusinessException {
        String selectorLayoutId = DataMapUtils.getTableLayoutId(pageView);
        HooksInfo hooksInfo = new HooksInfo();
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)parameters.get("hookOperationTypes")));
        String operationType = jsonArray.getString(0);
        if ("open".equalsIgnoreCase(operationType)) {
            hooksInfo.setDynamicFunctions(Sets.newHashSet((Object[])new HookDynamicFunction[]{new HookDynamicFunction().setFunctionName("hookValidTip").setHookName("gridReadyHook").setParameter(parameters).setSourceId(selectorLayoutId)}));
        } else if ("click".equalsIgnoreCase(operationType)) {
            hooksInfo.setDynamicFunctions(Sets.newHashSet((Object[])new HookDynamicFunction[]{new HookDynamicFunction().setFunctionName("clickAssignment").setHookName("beforeSubmitHook").setParameter(parameters).setSourceId(selectorLayoutId)}));
        } else if ("modify".equalsIgnoreCase(operationType)) {
            hooksInfo.setDynamicFunctions(Sets.newHashSet((Object[])new HookDynamicFunction[]{new HookDynamicFunction().setFunctionName("hookValidTip").setHookName("gridReadyHook").setParameter(parameters).setSourceId(selectorLayoutId)}));
        }
        return hooksInfo;
    }

    @Override
    public Map<String, Object> buildParameters(MechanismAbility ability, Map<String, Object> parameters) {
        LimitAbilityBo bo = (LimitAbilityBo)ability;
        SingleStrategyWidget singleStrategyWidget = (SingleStrategyWidget)bo.getStrategies().get(0);
        LimitTaskActionPlan positiveTarget = (LimitTaskActionPlan)singleStrategyWidget.getPositiveTarget();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        ArrayList conditions = new ArrayList();
        fields.put("type", ((MechanismConditionConfig)positiveTarget.getConditions().get(0)).getLimitType());
        positiveTarget.getConditions().stream().forEach(v -> {
            HashMap<String, Object> condition = new HashMap<String, Object>();
            MechanismVariable left = v.getLeft();
            condition.put("data_type", left.getData_type());
            condition.put("data_name", left.getData_name());
            if (null != v.getRight()) {
                condition.put("opType", v.getOpType());
                condition.put("toValue", v.getRight().getTo() == null ? null : v.getRight().getTo().getValue());
                condition.put("fromValue", v.getRight().getFrom() == null ? null : v.getRight().getFrom().getValue());
            }
            condition.put("limitTip", v.getLimitTip());
            conditions.add(condition);
        });
        fields.put("conditions", conditions);
        parameters.put("hookLimitData", fields);
        return parameters;
    }
}

