/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.hooks;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.JSFunctions;
import com.digiwin.athena.datamap.mechanism.convert.parsers.hooks.HooksParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SelectorParser
implements HooksParser {
    @Autowired
    JSFunctions jsFunctions;

    @Override
    public boolean accept(MechanismConditionConfig config) {
        return MechanismEnum.ComponentType.SELECTOR.getCode().equalsIgnoreCase(config.getMetaFieldType()) || config.getMetaFieldType() == null;
    }

    @Override
    public HooksInfo parse(MechanismConditionConfig config, BindingContext context, PageView pageView, Map<String, Object> parameters) throws DWBusinessException {
        String selectorLayoutId = DataMapUtils.getSelectorLayoutId(pageView, context.getMechanismVariables().get("hookSelectorInitDataFieldParam").toString());
        if (CollectionUtils.isEmpty(parameters)) {
            parameters = new HashMap<String, Object>();
        }
        HooksInfo hooksInfo = new HooksInfo().setDynamicFunctions(Sets.newHashSet((Object[])new HookDynamicFunction[]{new HookDynamicFunction().setFunctionName("hookSelectorInitData").setHookName("afterViewInitHook").setParameter(parameters).setSourceId(selectorLayoutId), new HookDynamicFunction().setFunctionName("hookSelectorSingleInitData").setHookName("valueChangesHook").setParameter(parameters).setSourceId(selectorLayoutId)}));
        return hooksInfo;
    }

    @Override
    public Map<String, Object> buildParameters(MechanismAbility ability, Map<String, Object> parameters) {
        return parameters;
    }
}

