/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksConverter;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.hooks.HooksParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.widgets.config.DecisionScene;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ApiParser
implements JudgeBasisParser {
    private static final Logger log = LoggerFactory.getLogger(ApiParser.class);
    @Autowired
    HooksConverter hooksConverter;
    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.ConditionType.API.getCode().equalsIgnoreCase(type);
    }

    @Override
    public void parse(MechanismAbility ability, PageView pageView, BindingContext context, HooksInfo hooksInfoAll) {
        DecisionAbilityBO bo = (DecisionAbilityBO)ability;
        context.getMechanismVariables().put("hookSelectorInitDataFieldParam", bo.getVariable().getData_name());
        bo.getDecisionOption().getScenes().stream().forEach(v -> {
            try {
                this.parseScene((DecisionScene)v, context, pageView, hooksInfoAll);
            }
            catch (DWException e) {
                log.error("ApiParser.parse \u89e3\u6790\u573a\u666f\u5224\u65ad\u6761\u4ef6\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570ability\uff1a{}\uff0cpageView\uff1a{}\uff0ccontext\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{v, pageView, context, e});
            }
        });
        this.packageHookInfo(pageView, bo, hooksInfoAll);
    }

    private void packageHookInfo(PageView pageView, DecisionAbilityBO bo, HooksInfo hooksInfoAll) {
        String layoutId = DataMapUtils.getTableLayoutId(pageView);
        HashMap<String, Object> callApiParams = new HashMap<String, Object>();
        callApiParams.put("hookCallApiAppType", MechanismEnum.ConditionType.HALF_CUSTOM.getCode());
        callApiParams.put("hookCallApiFieldParam", bo.getVariable().getData_name());
        callApiParams.put("hookCallApiFieldValueParam", hooksInfoAll.getTargetMap());
        callApiParams.put("hookCallApiApiListParam", hooksInfoAll.getApiList());
        hooksInfoAll.getDynamicFunctions().add(new HookDynamicFunction().setFunctionName("hookCallApi").setHookName("gridReadyHook").setSourceId(layoutId).setParameter(callApiParams));
        hooksInfoAll.getDynamicFunctions().add(new HookDynamicFunction().setFunctionName("hookCallParamPrepare").setHookName("afterViewInitHook").setSourceId(layoutId).setParameter(callApiParams));
    }

    private void parseScene(DecisionScene scene, BindingContext context, PageView pageView, HooksInfo hooksInfoAll) throws DWException {
        if (!ObjectUtils.isEmpty((Object)scene)) {
            MechanismConditionConfig mechanismCondition;
            JSONObject map = JSON.parseObject((String)JSON.toJSONString((Object)scene));
            ArrayList targetList = new ArrayList();
            try {
                mechanismCondition = (MechanismConditionConfig)((MechanismConditionGroup)scene.getCheck().getGroups().get(0)).getConditions().get(0);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790pageView\u83b7\u53d6\u51b3\u7b56\u6761\u4ef6\u5931\u8d25\uff0c\u53c2\u6570scenes\uff1a{}", (Object)scene);
                throw new DWException("\u89e3\u6790pageView\u83b7\u53d6\u51b3\u7b56\u6761\u4ef6\u5931\u8d25");
            }
            HooksParser hooksParser = this.mechanismParserFactory.getHooksParserByConfig(mechanismCondition);
            if (null == hooksParser) {
                log.error("ApiParser.parseScene \u83b7\u53d6HooksParser\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)scene);
            }
            HooksInfo hooksInfo = hooksParser.parse(mechanismCondition, context, pageView, null);
            hooksInfoAll.getDynamicFunctions().addAll(hooksInfo.getDynamicFunctions());
            try {
                JSONArray mechanismApiInfoArray = JSON.parseArray((String)JSON.toJSONString((Object)JsonPath.read((Object)map, (String)"$.check.groups[*].conditions[*].mechanismApiInfo", (Predicate[])new Predicate[0])));
                JSONObject mechanismApiInfo = (JSONObject)mechanismApiInfoArray.get(0);
                String apiUrl = mechanismApiInfo.getString("serviceId");
                String hasSchema = mechanismApiInfo.getString("hasScheme");
                JSONObject requestJson = mechanismApiInfo.getJSONObject("requestJson");
                HashMap<String, Object> apiInfo = new HashMap<String, Object>();
                HashMap<String, Object> paramsInfo = new HashMap<String, Object>();
                HashMap<String, HashMap<String, Object>> req = new HashMap<String, HashMap<String, Object>>();
                paramsInfo.put("api", apiUrl);
                paramsInfo.put("requestJson", new Object());
                paramsInfo.put("isNeedEsp", Boolean.TRUE);
                paramsInfo.put("keyFieldNameList", Lists.newArrayList((Object[])new String[]{"bk_info"}));
                req.put("req", paramsInfo);
                apiInfo.put("params", req);
                if (null != requestJson) {
                    log.info("HooksConverter.convert requestJson:{}", (Object)requestJson);
                    paramsInfo.put("requestJson", requestJson);
                }
                if ("true".equalsIgnoreCase(StrUtil.toString((Object)hasSchema))) {
                    apiInfo.put("type", "api");
                } else {
                    apiInfo.put("type", "target");
                }
                Object targets = JsonPath.read((Object)map, (String)"$.targets", (Predicate[])new Predicate[0]);
                targetList.addAll(Lists.newArrayList((Iterable)JSON.parseArray((String)JSON.toJSONString((Object)targets))));
                hooksInfoAll.getTargetMap().put(apiUrl, targetList);
                hooksInfoAll.getApiList().add(apiInfo);
            }
            catch (Exception e) {
                log.error("\u89e3\u6790pageView\u83b7\u53d6API\u670d\u52a1\u5931\u8d25\uff0cscenes\uff1a{}", (Object)scene);
                throw new DWException("\u89e3\u6790pageView\u83b7\u53d6API\u670d\u52a1\u5931\u8d25");
            }
        }
    }
}

