/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.convert.CustomFuncResult;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.RightCondTypeParser;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TaskParser
implements RightCondTypeParser {
    private static final Logger log = LoggerFactory.getLogger(TaskParser.class);
    @Autowired
    MechanismParserFactory mechanismParserFactory;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.RightCondType.TASK.getCode().equalsIgnoreCase(type);
    }

    @Override
    public CustomFuncResult preParse(MechanismConditionConfig conditionConfig, JSONArray metaDataList) {
        if (CollectionUtils.isEmpty((Collection)metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        MechanismVariable left = conditionConfig.getLeft();
        MechanismVariable right = conditionConfig.getRight();
        Object functionValue = left.getFunctionValue();
        String opType = conditionConfig.getOpType();
        String outputType = left.getMechanismFunction().getOutputType();
        String dataNameFrom = right.getFrom().getData_name();
        String dataNameTo = right.getTo().getData_name();
        List resultList = metaDataList.stream().filter(v -> {
            JSONObject metaDataObj = JSON.parseObject((String)JSON.toJSONString((Object)v));
            return this.mechanismParserFactory.getFieldTypeParserByConfig(outputType).isBothEqual(functionValue, this.getArrayChild(functionValue, metaDataObj, dataNameFrom, opType, "left"), this.getArrayChild(functionValue, metaDataObj, dataNameTo, opType, "right"), opType);
        }).collect(Collectors.toList());
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE).setMetaDataList(JSONArray.parseArray((String)JSON.toJSONString(resultList)));
    }

    private Object getArrayChild(Object functionValue, JSONObject metaDataObj, String name, String opType, String type) {
        if (ObjectUtils.isEmpty((Object)name)) {
            return null;
        }
        if (!name.contains(".")) {
            return metaDataObj.get((Object)name);
        }
        String[] names = name.split("[/.]");
        Object parent = metaDataObj.get((Object)names[0]);
        JSONArray parentArray = JSON.parseArray((String)JSON.toJSONString((Object)parent));
        if (MechanismEnum.OperateType.GT.getCode().equals(opType) || MechanismEnum.OperateType.GTE.equals((Object)opType)) {
            Optional<BigDecimal> max = parentArray.stream().map(v -> {
                JSONObject parseObject = JSON.parseObject((String)JSON.toJSONString((Object)v));
                return parseObject.getBigDecimal(names[1]);
            }).filter(v -> null != v).max(BigDecimal::compareTo);
            return max.isPresent() ? max.get() : null;
        }
        if (MechanismEnum.OperateType.LT.getCode().equals(opType) || MechanismEnum.OperateType.LTE.equals((Object)opType)) {
            Optional<BigDecimal> min = parentArray.stream().map(v -> {
                JSONObject parseObject = JSON.parseObject((String)JSON.toJSONString((Object)v));
                return parseObject.getBigDecimal(names[1]);
            }).filter(v -> null != v).min(BigDecimal::compareTo);
            return min.isPresent() ? min.get() : null;
        }
        if (MechanismEnum.OperateType.EQ.getCode().equals(opType)) {
            BigDecimal functionValueBigDecimal = new BigDecimal(functionValue.toString());
            Optional<BigDecimal> equal = parentArray.stream().map(v -> {
                JSONObject parseObject = JSON.parseObject((String)JSON.toJSONString((Object)v));
                return parseObject.getBigDecimal(names[1]);
            }).filter(v -> functionValueBigDecimal.compareTo((BigDecimal)v) == 0).findFirst();
            return equal.isPresent() ? equal.get() : null;
        }
        if (MechanismEnum.OperateType.BETWEEN.getCode().equals(opType)) {
            if ("left".equals(type)) {
                Optional<BigDecimal> between = parentArray.stream().map(v -> {
                    JSONObject parseObject = JSON.parseObject((String)JSON.toJSONString((Object)v));
                    return parseObject.getBigDecimal(names[1]);
                }).filter(v -> null != v).min(BigDecimal::compareTo);
                return between.isPresent() ? between.get() : null;
            }
            if ("right".equals(type)) {
                Optional<BigDecimal> between = parentArray.stream().map(v -> {
                    JSONObject parseObject = JSON.parseObject((String)JSON.toJSONString((Object)v));
                    return parseObject.getBigDecimal(names[1]);
                }).filter(v -> null != v).max(BigDecimal::compareTo);
                return between.isPresent() ? between.get() : null;
            }
        }
        return null;
    }

    @Override
    public CustomFuncResult parse(MechanismConditionConfig config, JSONObject metaDataObj, JSONArray metaDataList) {
        if (ObjectUtils.isEmpty((Object)metaDataObj) && ObjectUtils.isEmpty((Object)metaDataList)) {
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
        }
        if (ObjectUtils.isEmpty((Object)config.getOpenWindowActionId())) {
            String dataName = config.getLeft().getData_name();
            Boolean metaData = metaDataObj.getBooleanValue(dataName);
            config.getRight().getTo().setValue((Object)metaData);
            return new CustomFuncResult().setIsNeedNextJudge(Boolean.TRUE);
        }
        return new CustomFuncResult().setIsNeedNextJudge(Boolean.FALSE);
    }
}

