/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.decisionHandler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.convert.HooksConverter;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DecisionCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(DecisionCommonUtil.class);
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    HooksConverter hooksConverter;

    public void postRemovePlugin(String tenantId, String pluginId) throws DWException {
        Query queryDelete = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("pluginId").in(new Object[]{pluginId}));
        this.dataPickService.tenantTemplate().remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
    }

    public void addMechanismParameter(MechanismParseContext parseContext, HooksInfo hooksInfoAll, PageView pageView) {
        BindingContext bindingContext = parseContext.getBindingContext();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        if ("taskSource".equals(sourceWidget.getType())) {
            TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismDecision.name());
            this.buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll);
            this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    private void buildPageAdaptation(PageView pageView, TenantObjectAdaptation pageViewAdaptation, HooksInfo hooksInfoAll) {
        String path;
        JSONArray oldHooks;
        JSONObject pages = new JSONObject(pageView.getPages());
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        if (dataStates != null && !dataStates.isEmpty()) {
            JSONObject dataState = dataStates.getJSONObject(0);
            oldHooks = dataState.getJSONArray("hooks");
        } else {
            JSONObject taskDetail = pages.getJSONObject("task-detail");
            oldHooks = taskDetail.getJSONArray("hooks");
        }
        if (ObjectUtils.isEmpty((Object)oldHooks)) {
            pageViewAdaptation.setDateType("object");
            pageViewAdaptation.setOp("put");
            path = "$.pages.task-detail.dataStates[?(@.code == 'waitting')]";
            pageViewAdaptation.setPath(path);
            pageViewAdaptation.setAttribute("hooks");
            pageViewAdaptation.setValue(this.hooksConverter.buildHooks(hooksInfoAll));
            return;
        }
        pageViewAdaptation.setDateType("object");
        pageViewAdaptation.setOp("comb");
        path = "$.pages.task-detail.dataStates[0].hooks";
        pageViewAdaptation.setPath(path);
        pageViewAdaptation.setValue(this.hooksConverter.buildHooks(hooksInfoAll));
    }
}

