/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitCommonUtil;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitHandler;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.AutoProcessCondition;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.config.RuleTrigger;
import com.digiwin.athena.mechanism.widgets.plan.AutoProcessPlan;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoProcessHandler
extends LimitCommonUtil
implements LimitHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoProcessHandler.class);
    @Autowired
    PresetLibraryService presetLibraryService;
    private static final List<String> APC_TASK_CODES = Arrays.asList("apc_team_dispatch", "apc_workShopOnline", "LaunchWorkOrderOnlineAdjustmentProject");

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.autoProcessPlan.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        List<Rule> rules = this.buildRules(singleStrategyWidget, parseContext);
        for (Rule rule : rules) {
            this.presetLibraryService.saveRule(rule);
        }
    }

    private List<Rule> buildRules(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        String domainId;
        AutoProcessPlan autoProcessPlan = this.mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(), AutoProcessPlan.class);
        autoProcessPlan.setIsRelationScript(Boolean.TRUE);
        ArrayList<Rule> list = new ArrayList<Rule>();
        autoProcessPlan.setIsRelationScript(Boolean.valueOf(false));
        list.add(this.readOnlyRule(singleStrategyWidget, parseContext, autoProcessPlan));
        String string = domainId = parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget();
        if (!"apc_team_dispatch".equals(domainId)) {
            list.add(this.requiredRule(singleStrategyWidget, parseContext, autoProcessPlan));
        }
        autoProcessPlan.setIsRelationScript(Boolean.valueOf(true));
        list.add(this.linkageModificationRuleNew(singleStrategyWidget, parseContext, autoProcessPlan));
        return list;
    }

    private Rule requiredRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext, AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        String code;
        RuleContent ruleContent = (RuleContent)JSON.parseObject((String)JSON.toJSONString((Object)autoProcessPlan.getRuleContent()), RuleContent.class);
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        HashMap<String, Object> content = new HashMap<String, Object>();
        Rule rule = new Rule();
        rule.setContent(content);
        this.ruleCommonSet(parseContext, rule);
        RuleTrigger trigger = ruleContent.getTrigger();
        String path = subParameter.getField().getPath();
        int len = path.lastIndexOf(".");
        content.put("path", path.substring(0, len));
        content.put("schema", path.substring(len + 1));
        content.put("key", "required");
        if (autoProcessPlan.getIsAsync().booleanValue()) {
            content.put("checkEmptyForAsyncRequired", true);
        }
        if (autoProcessPlan.getIsAsync().booleanValue()) {
            trigger.setPoint("default");
            content.put("trigger", trigger);
        }
        this.attributeAndLang(content, subParameter.getField(), "errorMessage", "\u5fc5\u586b");
        content.put("description", "limitTaskAction");
        LinkedHashSet<DynamicFunction> dynamicFunctions = new LinkedHashSet<DynamicFunction>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<String>();
        this.expression(singleStrategyWidget, (LimitPlan)autoProcessPlan, parseContext, dynamicFunctions, expressionList);
        if (CollectionUtils.isNotEmpty((Collection)subParameter.getConditions()) && StringUtils.isNotEmpty((CharSequence)(code = ((MechanismVariable)subParameter.getConditions().get(0)).getCode()))) {
            ArrayList<String> parameter2 = new ArrayList<String>();
            String subDataName = ((MechanismVariable)subParameter.getConditions().get(0)).getData_name();
            parameter2.add("!subMap[currentControl.parent.get('" + subDataName + "').value]");
            ArrayList<String> parameter3 = new ArrayList<String>();
            String parDataName = ((MechanismVariable)parentParameter.getConditions().get(0)).getData_name();
            if (autoProcessPlan.getConditionPatch().booleanValue()) {
                parameter3.add("currentControl.parent.get('wo_no').value==item.wo_no");
            }
            String verifyWhetherTheMainProcess = "subMap[currentControl.parent.get('" + subDataName + "').value].includes(item." + parDataName + ")";
            parameter3.add(verifyWhetherTheMainProcess);
            String verifyWoProperty = "item.wo_property !== '2'";
            parameter3.add(verifyWoProperty);
            if ("apiCheck_APC".equals(autoProcessPlan.getLimitType())) {
                expressionList.add("(controlRequired&&!apiDataContain(subMap[currentControl.parent.get('" + subDataName + "').value]))");
            } else {
                expressionList.add("controlRequired");
            }
            String controlRequiredConditionFunction = "apc_team_dispatch".equals(rule.getDomainId()) ? "controlRequiredCondition_apc_team_dispatch" : "controlRequiredCondition";
            dynamicFunctions.add(DynamicFunction.builder().functionName(controlRequiredConditionFunction).parameter((Map<String, String>)ImmutableMap.of((Object)"parameter1", (Object)code, (Object)"parameter2", (Object)String.join((CharSequence)" && ", parameter2), (Object)"parameter3", (Object)String.join((CharSequence)" && ", parameter3))).build());
            this.addMechanismParameter(parseContext, code);
        }
        String expression = String.join((CharSequence)" && ", expressionList);
        sb.append("if(").append(expression).append("){ return true}");
        String functionExp = this.jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }
        sb.insert(0, "(() => {");
        sb.append("})()");
        if (autoProcessPlan.getIsAsync().booleanValue()) {
            trigger.setCondition(sb.toString());
        } else {
            content.put("condition", sb.toString());
        }
        return rule;
    }

    private Rule linkageModificationRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext, AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        RuleContent ruleContent = (RuleContent)JSON.parseObject((String)JSON.toJSONString((Object)autoProcessPlan.getRuleContent()), RuleContent.class);
        Rule rule = new Rule();
        HashMap<String, Object> content = new HashMap<String, Object>();
        this.ruleCommonSet(parseContext, rule);
        rule.setContent(content);
        RuleTrigger trigger = ruleContent.getTrigger();
        List params = autoProcessPlan.getParams();
        if (autoProcessPlan.getIsAsync().booleanValue()) {
            trigger.setPoint("dataChanged");
            content.put("trigger", trigger);
        }
        if (CollectionUtils.isNotEmpty((Collection)params)) {
            String path = ((MechanismVariable)params.get(0)).getPath();
            int len = path.lastIndexOf(".");
            content.put("path", path.substring(0, len));
            content.put("schema", path.substring(len + 1));
            content.put("key", "connection");
        } else {
            content.put("key", "connection");
        }
        content.put("description", "limitTaskAction");
        ArrayList relations = new ArrayList();
        HashMap<String, Object> relation = new HashMap<String, Object>();
        relation.put("path", subParameter.getField().getData_name());
        HashMap<String, String> operation = new HashMap<String, String>();
        operation.put("type", "script");
        LinkedHashSet<DynamicFunction> dynamicFunctions = new LinkedHashSet<DynamicFunction>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<String>();
        this.expression(singleStrategyWidget, (LimitPlan)autoProcessPlan, parseContext, dynamicFunctions, expressionList);
        String code = ((MechanismVariable)subParameter.getConditions().get(0)).getCode();
        this.addMechanismParameter(parseContext, code);
        String parDataName = ((MechanismVariable)parentParameter.getConditions().get(0)).getData_name();
        String subDataName = ((MechanismVariable)subParameter.getConditions().get(0)).getData_name();
        String sourceField = parentParameter.getField().getData_name();
        String targetField = subParameter.getField().getData_name();
        ArrayList<String> parameter2 = new ArrayList<String>();
        parameter2.add("parSet.includes(currentControl.parent.get('" + parDataName + "').value)");
        expressionList.add("isPar");
        dynamicFunctions.add(DynamicFunction.builder().functionName("isPar").parameter((Map<String, String>)ImmutableMap.of((Object)"parameter1", (Object)code, (Object)"parameter2", (Object)String.join((CharSequence)" && ", parameter2))).build());
        ArrayList<String> parameter3 = new ArrayList<String>();
        parameter3.add("(map[currentControl.parent.get('" + parDataName + "').value].includes(item.get('" + subDataName + "').value)||currentControl.parent.get('" + parDataName + "').value==item.get('" + parDataName + "').value)");
        if (autoProcessPlan.getConditionPatch().booleanValue()) {
            parameter3.add("currentControl.parent.get('wo_no').value==item.get('wo_no').value");
        }
        String expression = String.join((CharSequence)" && ", expressionList);
        sb.append("if(").append(expression).append("){");
        String functionExp = this.jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }
        String supplementJs = this.complementaryLogic(targetField, sourceField);
        String replaceJs = "item.get('" + targetField + "').setValue(currentControl.parent.get('" + sourceField + "').value);if(item.get('uibot_checked')!==null&&item.get('uibot_checked')!==undefined&&currentControl.parent.get('uibot_checked')!==null&&currentControl.parent.get('uibot_checked')!==undefined){item.get('uibot_checked').setValue(currentControl.parent.get('uibot_checked').value)}" + supplementJs;
        String autoProcessDataFunction = "apc_team_dispatch".equals(rule.getDomainId()) ? "autoProcessData_apc_team_dispatch" : "autoProcessData";
        sb.append(this.jsExpressionConverter.dynamicFunctionExpression(Collections.singleton(DynamicFunction.builder().functionName(autoProcessDataFunction).parameter((Map<String, String>)ImmutableMap.of((Object)"parameter3", (Object)String.join((CharSequence)" && ", parameter3), (Object)"parameter4", (Object)replaceJs, (Object)"parameter5", (Object)subDataName)).build()))).append("}");
        sb.insert(0, "(() => {");
        sb.append("})()");
        operation.put("script", sb.toString());
        relation.put("operations", Collections.singletonList(operation));
        relations.add(relation);
        content.put("relations", relations);
        return rule;
    }

    private Rule linkageModificationRuleNew(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext, AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        String domainId;
        String string = domainId = parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget();
        if (!APC_TASK_CODES.contains(domainId)) {
            return this.linkageModificationRule(singleStrategyWidget, parseContext, autoProcessPlan);
        }
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        RuleContent ruleContent = (RuleContent)JSON.parseObject((String)JSON.toJSONString((Object)autoProcessPlan.getRuleContent()), RuleContent.class);
        Rule rule = new Rule();
        HashMap<String, Object> content = new HashMap<String, Object>();
        this.ruleCommonSet(parseContext, rule);
        rule.setContent(content);
        List params = autoProcessPlan.getParams();
        RuleTrigger trigger = ruleContent.getTrigger();
        if (autoProcessPlan.getIsAsync().booleanValue()) {
            String parameterScript = trigger.getParameterScript();
            parameterScript = parameterScript.replace("bm.dsc.wo.op.dispatch.get", "bm.dsc.wo.op.dispatch.get_connection_rule").replace("day_plan_data", "apc_day_plan_data").replace("bm.dpsc.working.day.plan.get", "apc.working.day.plan.dispatch.info.get");
            trigger.setParameterScript(parameterScript);
            trigger.setPoint("dataChanged");
            content.put("trigger", trigger);
        }
        if (CollectionUtils.isNotEmpty((Collection)params)) {
            String path = ((MechanismVariable)params.get(0)).getPath();
            int len = path.lastIndexOf(".");
            content.put("path", path.substring(0, len));
            content.put("schema", path.substring(len + 1));
            content.put("key", "connection");
        } else {
            content.put("key", "connection");
        }
        content.put("description", "limitTaskAction");
        ArrayList relations = new ArrayList();
        HashMap<String, Object> relation = new HashMap<String, Object>();
        relation.put("path", subParameter.getField().getData_name());
        HashMap<String, String> operation = new HashMap<String, String>();
        operation.put("type", "script");
        LinkedHashSet<DynamicFunction> dynamicFunctions = new LinkedHashSet<DynamicFunction>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<String>();
        this.expression(singleStrategyWidget, (LimitPlan)autoProcessPlan, parseContext, dynamicFunctions, expressionList);
        String code = ((MechanismVariable)subParameter.getConditions().get(0)).getCode();
        this.addMechanismParameter(parseContext, code);
        String parDataName = ((MechanismVariable)parentParameter.getConditions().get(0)).getData_name();
        String subDataName = ((MechanismVariable)subParameter.getConditions().get(0)).getData_name();
        String sourceField = parentParameter.getField().getData_name();
        String targetField = subParameter.getField().getData_name();
        String autoProcessDataFunction = "LaunchWorkOrderOnlineAdjustmentProject".equals(domainId) ? "LaunchWorkOrderOnlineAdjustmentProject" : ("apc_workShopOnline".equals(rule.getDomainId()) ? "apc_workShopOnline_new" : "autoProcessData_apc_team_dispatch_new");
        sb.append(this.jsExpressionConverter.dynamicFunctionExpression(Collections.singleton(DynamicFunction.builder().functionName(autoProcessDataFunction).parameter((Map<String, String>)ImmutableMap.of((Object)"parameter1", (Object)parDataName, (Object)"parameter2", (Object)subDataName, (Object)"parameter3", (Object)sourceField, (Object)"parameter4", (Object)targetField)).build())));
        sb.insert(0, "(() => {");
        sb.append("})()");
        operation.put("script", sb.toString());
        relation.put("operations", Collections.singletonList(operation));
        relations.add(relation);
        content.put("relations", relations);
        return rule;
    }

    private String complementaryLogic(String targetField, String sourceField) {
        String targetFieldLink = null;
        String sourceFieldLink = null;
        if (targetField.endsWith("_no")) {
            targetFieldLink = targetField.replace("_no", "_name");
        }
        if (targetField.endsWith("_name")) {
            targetFieldLink = targetField.replace("_name", "_no");
        }
        if (sourceField.endsWith("_no")) {
            sourceFieldLink = sourceField.replace("_no", "_name");
        }
        if (sourceField.endsWith("_name")) {
            sourceFieldLink = sourceField.replace("_name", "_no");
        }
        if (StringUtils.isNotEmpty((CharSequence)targetFieldLink) && StringUtils.isNotEmpty((CharSequence)sourceFieldLink)) {
            return "if (item.get('" + targetFieldLink + "') !== null && item.get('" + targetFieldLink + "') !== undefined && currentControl.parent.get('" + sourceFieldLink + "') !== null && currentControl.parent.get('" + sourceFieldLink + "') !== undefined) {item.get('" + targetFieldLink + "').setValue(currentControl.parent.get('" + sourceFieldLink + "').value);}";
        }
        return "";
    }

    private Rule readOnlyRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext, AutoProcessPlan autoProcessPlan) throws DWBusinessException {
        String code;
        RuleContent ruleContent = (RuleContent)JSON.parseObject((String)JSON.toJSONString((Object)autoProcessPlan.getRuleContent()), RuleContent.class);
        AutoProcessCondition subParameter = autoProcessPlan.getSubParameter();
        AutoProcessCondition parentParameter = autoProcessPlan.getParentParameter();
        Rule rule = new Rule();
        HashMap<String, String> content = new HashMap<String, String>();
        rule.setContent(content);
        this.ruleCommonSet(parseContext, rule);
        RuleTrigger trigger = ruleContent.getTrigger();
        String path = subParameter.getField().getPath();
        int len = path.lastIndexOf(".");
        content.put("path", path.substring(0, len));
        content.put("schema", path.substring(len + 1));
        content.put("key", "disabled");
        if (autoProcessPlan.getIsAsync().booleanValue()) {
            trigger.setPoint("default");
            content.put("trigger", (String)trigger);
        }
        content.put("description", "limitTaskAction");
        LinkedHashSet<DynamicFunction> dynamicFunctions = new LinkedHashSet<DynamicFunction>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<String>();
        this.expression(singleStrategyWidget, (LimitPlan)autoProcessPlan, parseContext, dynamicFunctions, expressionList);
        if (CollectionUtils.isNotEmpty((Collection)subParameter.getConditions()) && StringUtils.isNotEmpty((CharSequence)(code = ((MechanismVariable)subParameter.getConditions().get(0)).getCode()))) {
            ArrayList<String> parameter2 = new ArrayList<String>();
            String subDataName = ((MechanismVariable)subParameter.getConditions().get(0)).getData_name();
            parameter2.add("!subMap[currentControl.parent.get('" + subDataName + "').value]");
            ArrayList<String> parameter3 = new ArrayList<String>();
            String parDataName = ((MechanismVariable)parentParameter.getConditions().get(0)).getData_name();
            if (autoProcessPlan.getConditionPatch().booleanValue()) {
                parameter3.add("currentControl.parent.get('wo_no').value==item.wo_no");
            }
            String verifyWhetherTheMainProcess = "subMap[currentControl.parent.get('" + subDataName + "').value].includes(item." + parDataName + ")";
            parameter3.add(verifyWhetherTheMainProcess);
            String verifyWoProperty = "item.wo_property !== '2'";
            parameter3.add(verifyWoProperty);
            if ("apiCheck_APC".equals(autoProcessPlan.getLimitType())) {
                expressionList.add("(controlReadOnly||apiDataContain(subMap[currentControl.parent.get('" + subDataName + "').value]))");
            } else {
                expressionList.add("controlReadOnly");
            }
            String controlReadOnlyFunction = "apc_team_dispatch".equals(rule.getDomainId()) ? "controlReadOnlyCondition_apc_team_dispatch" : "controlReadOnlyCondition";
            dynamicFunctions.add(DynamicFunction.builder().functionName(controlReadOnlyFunction).parameter((Map<String, String>)ImmutableMap.of((Object)"parameter1", (Object)code, (Object)"parameter2", (Object)String.join((CharSequence)" && ", parameter2), (Object)"parameter3", (Object)String.join((CharSequence)" && ", parameter3))).build());
            this.addMechanismParameter(parseContext, code);
        }
        String expression = String.join((CharSequence)" && ", expressionList);
        sb.append("if(").append(expression).append("){ return true}");
        String functionExp = this.jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }
        sb.insert(0, "(() => {");
        sb.append("})()");
        if (autoProcessPlan.getIsAsync().booleanValue()) {
            trigger.setCondition(sb.toString());
        } else {
            content.put("condition", sb.toString());
        }
        return rule;
    }
}

