/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitHandler;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.ButtonInfo;
import com.digiwin.athena.mechanism.widgets.plan.ButtonLimit;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.seata.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ButtonLimitHandler
implements LimitHandler {
    public static final String TASK_BUTTON_PATH_PREFIX = "$.pages.task-detail";
    public static final String PROJECT_BUTTON_PATH_PREFIX = "$.pages.project-detail";
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.buttonLimit.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    @Transactional
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) {
        String tenantId = null;
        try {
            tenantId = ServiceUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException("getTenantId error:" + e.getMessage());
        }
        String conditionScript = this.mechanismHelpService.toExpression(singleStrategyWidget.getCondition(), parseContext);
        String pageCode = this.findPageCode(parseContext.getSourceWidget());
        ButtonLimit buttonLimit = this.mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(), ButtonLimit.class);
        List buttons = buttonLimit.getButtons();
        if (!CollectionUtils.isEmpty((Collection)buttons)) {
            ArrayList<TenantObjectAdaptation> adaptations = new ArrayList<TenantObjectAdaptation>();
            for (ButtonInfo buttonInfo : buttons) {
                String path = this.getPath(buttonInfo, parseContext.getSourceWidget().getType());
                TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
                tenantObjectAdaptation.setCode(pageCode);
                tenantObjectAdaptation.setTenantId(tenantId);
                tenantObjectAdaptation.setPluginId(parseContext.getBindingContext().getPluginId());
                tenantObjectAdaptation.setPath(path);
                if (StringUtils.isEmpty((CharSequence)buttonLimit.getAction()) || StringUtils.equals((String)buttonLimit.getAction(), (String)"disable")) {
                    tenantObjectAdaptation.setValue((Object)("!(" + conditionScript + ")"));
                } else {
                    tenantObjectAdaptation.setValue((Object)conditionScript);
                }
                tenantObjectAdaptation.setDateType("string");
                tenantObjectAdaptation.setOp("put");
                tenantObjectAdaptation.setAttribute("condition");
                adaptations.add(tenantObjectAdaptation);
                if (!StringUtils.isEmpty((CharSequence)buttonLimit.getTrigger()) && !StringUtils.equals((String)buttonLimit.getTrigger(), (String)"dataChanged")) continue;
                TenantObjectAdaptation tenantObjectAdaptation2 = new TenantObjectAdaptation();
                BeanUtils.copyProperties((Object)tenantObjectAdaptation, (Object)tenantObjectAdaptation2);
                tenantObjectAdaptation2.setValue((Object)"dataChanged");
                tenantObjectAdaptation2.setAttribute("trigger");
                adaptations.add(tenantObjectAdaptation2);
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)parseContext.getBindingContext().getPluginId()).and("tenantId").is((Object)tenantId).and("code").is((Object)pageCode));
            this.dataPickService.tenantTemplate().remove(query, DataPickService.tableTenantObjectAdaptation(PageView.class));
            this.dataPickService.tenantTemplate().insert(adaptations, DataPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    private String getPath(ButtonInfo buttonInfo, String checkSourceType) {
        StringBuilder sb = new StringBuilder();
        sb.append(".dataStates[?(@.code == '" + buttonInfo.getDataStateCode() + "')]").append(".").append(buttonInfo.getButtonType()).append("[?(@.title == '" + buttonInfo.getTitle() + "'");
        if (StringUtils.isNotEmpty((CharSequence)buttonInfo.getMode())) {
            sb.append(" && @.mode == '" + buttonInfo.getMode() + "'");
        }
        if (StringUtils.isNotEmpty((CharSequence)buttonInfo.getApplyToField())) {
            sb.append(" && @.applyToField == '" + buttonInfo.getApplyToField() + "'");
        }
        sb.append(")]");
        if ("taskSource".equalsIgnoreCase(checkSourceType)) {
            return TASK_BUTTON_PATH_PREFIX + sb.toString();
        }
        if ("projectSource".equalsIgnoreCase(checkSourceType)) {
            return PROJECT_BUTTON_PATH_PREFIX + sb.toString();
        }
        return null;
    }

    private String findPageCode(SourceWidget sourceWidget) {
        try {
            if ("taskSource".equalsIgnoreCase(sourceWidget.getType())) {
                Task sourceTask = (Task)this.dataPickService.findBetter(sourceWidget.getTarget(), Task.class);
                if (sourceTask == null) {
                    throw new RuntimeException("findPageCode error, not found task:" + sourceWidget.getTarget());
                }
                return sourceTask.getPageCode();
            }
            if ("projectSource".equalsIgnoreCase(sourceWidget.getType())) {
                Project sourceProject = (Project)this.dataPickService.findBetter(sourceWidget.getTarget(), Project.class);
                if (sourceProject == null) {
                    throw new RuntimeException("findPageCode error, not found project:" + sourceWidget.getTarget());
                }
                return sourceProject.getPageCode();
            }
        }
        catch (DWBusinessException e) {
            e.printStackTrace();
            throw new RuntimeException("findPageCode error:" + e.getMessage());
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", "1001");
            map.put("title", "title1");
            map.put("mode", "all");
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("id", "1002");
            map2.put("title", "title2");
            map2.put("mode", "line");
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            list.add(map2);
            HashMap<String, Object> map3 = new HashMap<String, Object>();
            map3.put("operations", list);
            map3.put("code", "waitting");
            ArrayList<HashMap<String, Object>> list2 = new ArrayList<HashMap<String, Object>>();
            list2.add(map3);
            HashMap<String, ArrayList<HashMap<String, Object>>> map5 = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            map5.put("dataStates", list2);
            HashMap<String, HashMap<String, ArrayList<HashMap<String, Object>>>> map6 = new HashMap<String, HashMap<String, ArrayList<HashMap<String, Object>>>>();
            map6.put("task-Detail", map5);
            HashMap<String, HashMap<String, HashMap<String, ArrayList<HashMap<String, Object>>>>> map7 = new HashMap<String, HashMap<String, HashMap<String, ArrayList<HashMap<String, Object>>>>>();
            map7.put("pages", map6);
            System.out.println("map6==>" + map7);
            JsonPath.parse(map7).put("$.pages.task-Detail.dataStates[*].operations[?(@.id == '1001' && @.mode == 'all')]", "disableScript", (Object)"script...", new Predicate[0]);
            JsonPath.parse(map7).put("$.pages.task-Detail.dataStates[?(@.code == 'waitting')].operations[?(@.id == '1002')]", "disableScript", (Object)"script2...", new Predicate[0]);
            System.out.println(map7);
            ButtonInfo info = new ButtonInfo();
            info.setDataStateCode("waitting");
            info.setButtonType("submitActions");
            info.setTitle("\u63d0\u4ea4");
            System.out.println(new ButtonLimitHandler().getPath(info, "taskSource"));
            ButtonInfo info2 = new ButtonInfo();
            info2.setDataStateCode("waitting");
            info2.setButtonType("operations");
            info2.setMode("all");
            info2.setTitle("\u4fdd\u5b58");
            System.out.println(new ButtonLimitHandler().getPath(info2, "taskSource"));
            System.out.println(new ButtonLimitHandler().getPath(info2, "projectSource"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PageView pageView = new PageView();
        pageView.setCode("code01");
        pageView.setVersion("v1");
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)pageView));
        System.out.println(jsonObject);
        JsonPath.parse((Object)jsonObject).set("$.code", (Object)"code2", new Predicate[0]);
        JsonPath.parse((Object)jsonObject).set("$.version", (Object)"v2", new Predicate[0]);
        System.out.println(jsonObject);
    }
}

