/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksConverter;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.JsExpression;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionConverter;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.actions.ActionParam;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.JsExpressionType;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class LimitCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(LimitCommonUtil.class);
    @Autowired
    JsExpressionConverter jsExpressionConverter;
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    HooksConverter hooksConverter;
    @Autowired
    DataPickService dataPickService;

    public void addMechanismParameter(MechanismParseContext parseContext, String code) {
        ActionParam actionParam;
        String path;
        TenantObjectAdaptation tenantObjectAdaptation;
        BindingContext bindingContext = parseContext.getBindingContext();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        if ("taskSource".equals(sourceWidget.getType())) {
            tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setDateType("array");
            tenantObjectAdaptation.setOp("add");
            tenantObjectAdaptation.setType("TM_VARIABLE");
            path = "$.pages.task-detail.dataStates[0].submitActions[0].actionParams";
            tenantObjectAdaptation.setPath(path);
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
            actionParam = new ActionParam();
            actionParam.setName(code);
            actionParam.setType("TM_VARIABLE");
            actionParam.setValue((Object)code);
            actionParam.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setValue((Object)actionParam);
            this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
        if ("projectSource".equals(sourceWidget.getType())) {
            tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setDateType("object");
            tenantObjectAdaptation.setOp("put");
            tenantObjectAdaptation.setAttribute(ComponentTypeEnum.MechanismVariable.name());
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismLimit.name());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            path = "$.pages.task-detail";
            tenantObjectAdaptation.setPath(path);
            actionParam = new ActionParam();
            actionParam.setName(code);
            actionParam.setType("TM_VARIABLE");
            actionParam.setValue((Object)code);
            actionParam.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setValue((Object)actionParam);
            this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    public void postRemovePlugin(String tenantId, String pluginId) throws DWException {
        Query queryDelete = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("pluginId").in(new Object[]{pluginId}));
        this.dataPickService.tenantTemplate().remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
    }

    public void addMechanismParameter(LimitAbilityBo bo, MechanismParseContext parseContext, HooksInfo hooksInfoAll, PageView pageView) {
        Boolean isNeedObject;
        String wholePath;
        String partPath;
        TenantObjectAdaptation tenantObjectAdaptation;
        BindingContext bindingContext = parseContext.getBindingContext();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        List operationTypes = bo.getCheckSource().getOperationTypes();
        String operationType = (String)operationTypes.get(0);
        if ("taskSource".equals(sourceWidget.getType())) {
            tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismDecision.name());
            partPath = "";
            wholePath = "";
            if (operationType.equalsIgnoreCase("click")) {
                partPath = "$.pages.task-detail.dataStates[0].submitActions[?(@.actionId == '" + (String)operationTypes.get(1) + "')].hooks";
                wholePath = "$.pages.task-detail.dataStates[0].submitActions[?(@.actionId == '" + (String)operationTypes.get(1) + "')].hooks";
                isNeedObject = Boolean.TRUE;
                this.buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll, "$.pages.task-detail.dataStates[?(@.code == 'waitting')]", "$.pages.task-detail.dataStates[0].hooks", Boolean.FALSE);
                this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
            } else {
                partPath = "$.pages.task-detail.dataStates[?(@.code == 'waitting')]";
                wholePath = "$.pages.task-detail.dataStates[0].hooks";
                isNeedObject = Boolean.FALSE;
            }
            this.buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll, partPath, wholePath, isNeedObject);
            this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
        if ("projectSource".equals(sourceWidget.getType())) {
            tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismDecision.name());
            partPath = "";
            wholePath = "";
            if (operationType.equalsIgnoreCase("click")) {
                partPath = "$.pages.task-detail.dataStates[0].submitActions[?(@.actionId == '" + (String)operationTypes.get(1) + "')]";
                isNeedObject = Boolean.TRUE;
                this.buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll, "$.pages.task-detail.dataStates[?(@.code == 'waitting')]", "$.pages.task-detail.dataStates[0].hooks", Boolean.FALSE);
                this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
            } else {
                partPath = "$.pages.task-detail";
                wholePath = "$.pages.task-detail.hooks";
                isNeedObject = Boolean.FALSE;
            }
            this.buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll, partPath, wholePath, isNeedObject);
            tenantObjectAdaptation.setCode("start_" + tenantObjectAdaptation.getCode());
            this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    private void buildPageAdaptation(PageView pageView, TenantObjectAdaptation pageViewAdaptation, HooksInfo hooksInfoAll, String partPath, String wholePath, Boolean isNeedObject) {
        JSONArray oldHooks;
        JSONObject pages = new JSONObject(pageView.getPages());
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        if (dataStates != null && !dataStates.isEmpty()) {
            JSONObject dataState = dataStates.getJSONObject(0);
            oldHooks = dataState.getJSONArray("hooks");
        } else {
            JSONObject taskDetail = pages.getJSONObject("task-detail");
            oldHooks = taskDetail.getJSONArray("hooks");
        }
        if (ObjectUtils.isEmpty((Object)oldHooks)) {
            pageViewAdaptation.setDateType("object");
            pageViewAdaptation.setOp("put");
            pageViewAdaptation.setPath(partPath);
            pageViewAdaptation.setAttribute("hooks");
            pageViewAdaptation.setValue(isNeedObject != false ? this.hooksConverter.buildHooks(hooksInfoAll).get(0) : this.hooksConverter.buildHooks(hooksInfoAll));
            return;
        }
        pageViewAdaptation.setDateType("object");
        pageViewAdaptation.setOp("comb");
        pageViewAdaptation.setPath(wholePath);
        pageViewAdaptation.setValue(isNeedObject != false ? this.hooksConverter.buildHooks(hooksInfoAll).get(0) : this.hooksConverter.buildHooks(hooksInfoAll));
    }

    public void ruleCommonSet(MechanismParseContext parseContext, Rule rule) {
        rule.setApplication(parseContext.getBindingContext().getApplication());
        rule.setTenantId(parseContext.getBindingContext().getTenantId());
        rule.setPluginId(parseContext.getBindingContext().getPluginId());
        rule.setDomain(PresetDomainEnum.ACTIVITY);
        rule.setDescription(ComponentTypeEnum.MechanismLimit.name());
        rule.setDomainId(parseContext.getProjectPageTarget() == null ? parseContext.getSourceTarget() : parseContext.getProjectPageTarget());
        rule.setKey(this.mechanismHelpService.uid());
        rule.setSequence(999);
    }

    public void expression(SingleStrategyWidget singleStrategyWidget, LimitPlan plan, MechanismParseContext parseContext, Set<DynamicFunction> dynamicFunctions, ArrayList<String> expressionList) throws DWBusinessException {
        expressionList.add("true");
        boolean relationScript = plan.getIsRelationScript();
        String apiData = this.apiData(plan, relationScript);
        switch (plan.getLimitType()) {
            case "default": {
                break;
            }
            case "proficiency": {
                String cond = "";
                if (!ObjectUtils.isEmpty((Object)singleStrategyWidget.getPersonnelCondition().getPerformerValue())) {
                    cond = apiData + ".count < " + singleStrategyWidget.getPersonnelCondition().getPerformerValue();
                } else {
                    String type = singleStrategyWidget.getPersonnelCondition().getProficiencyType().name();
                    if (MechanismEnum.OperateType.EQ.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count  = " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.GT.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count  > " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.LT.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count  < " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.GTE.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count  >= " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.LTE.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count  <= " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                    if (MechanismEnum.OperateType.BETWEEN.getCode().equalsIgnoreCase(type)) {
                        cond = apiData + ".count  >= " + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getFromValue().toString()) + "&" + apiData + ".count <=" + Integer.valueOf(singleStrategyWidget.getPersonnelCondition().getToValue().toString());
                    }
                }
                expressionList.add("(" + cond + ")");
                break;
            }
            case "duty": {
                String performerValue = ObjectUtils.isEmpty((Object)singleStrategyWidget.getPersonnelCondition().getPerformerValue()) ? singleStrategyWidget.getPersonnelCondition().getToValue().toString() : singleStrategyWidget.getPersonnelCondition().getPerformerValue();
                String dutyValue = LimitCommonUtil.handleList(performerValue);
                expressionList.add("dutyMatch");
                dynamicFunctions.add(DynamicFunction.builder().functionName("dutyCondition").parameter((Map<String, String>)ImmutableMap.of((Object)"dutyParameter1", (Object)dutyValue, (Object)"dutyParameter2", (Object)apiData)).build());
                break;
            }
            case "staff": {
                String performerValueStaff = ObjectUtils.isEmpty((Object)singleStrategyWidget.getPersonnelCondition().getPerformerValue()) ? singleStrategyWidget.getPersonnelCondition().getToValue().toString() : singleStrategyWidget.getPersonnelCondition().getPerformerValue();
                String result = LimitCommonUtil.handleList(performerValueStaff);
                expressionList.add("staffMatch");
                dynamicFunctions.add(DynamicFunction.builder().functionName("staffCondition").parameter((Map<String, String>)ImmutableMap.of((Object)"parameter", (Object)result)).build());
                break;
            }
            case "apiCheck_APC": {
                dynamicFunctions.add(DynamicFunction.builder().functionName("apiCheck_APC").parameter((Map<String, String>)ImmutableMap.of((Object)"parameter1", (Object)(apiData + ".data"))).build());
                break;
            }
            case "businessCondition": {
                String mechanismVersion = parseContext.getBindingContext().getMechanismVersion();
                if (null == mechanismVersion) {
                    BindingContext bindingContext = new BindingContext();
                    if (MechanismPlanType.reminderPlan.name().equals(plan.getType())) {
                        bindingContext.setJsExpressionType(JsExpressionType.taskData);
                    } else {
                        bindingContext.setJsExpressionType(JsExpressionType.currentControl);
                    }
                    JsExpression jsExpression = this.jsExpressionConverter.convertByGroups(singleStrategyWidget.getBusinessCondition().getGroups(), bindingContext);
                    if (null == jsExpression) break;
                    dynamicFunctions.addAll(jsExpression.getDynamicFunction());
                    Set<String> function = jsExpression.getFunction();
                    for (String s : function) {
                        dynamicFunctions.add(DynamicFunction.builder().functionName(s).build());
                    }
                    if (null == jsExpression.getExpression()) break;
                    expressionList.add(jsExpression.getExpression());
                    break;
                }
                HashMap parameters = new HashMap();
                ArrayList apiList = new ArrayList();
                HashMap<String, Object> paramsInfo = new HashMap<String, Object>();
                HashMap<String, HashMap<String, Object>> req = new HashMap<String, HashMap<String, Object>>();
                paramsInfo.put("requestJson", new Object());
                paramsInfo.put("ability", parseContext.getBo());
                paramsInfo.put("isNeedEsp", Boolean.FALSE);
                req.put("apiInfoDTO", paramsInfo);
                parameters.put("hookApiList", apiList);
                String parameterScript = "var result =  JSON.parse('" + JSON.toJSONString(req) + "');result.tableData = currentControl.parent.parent.value; return result;";
                ReminderPlan positiveTarget = (ReminderPlan)singleStrategyWidget.getPositiveTarget();
                positiveTarget.getRuleContent().getTrigger().setParameterScript(parameterScript);
                expressionList.add("(" + apiData + ".data)");
                break;
            }
            default: {
                throw new DWBusinessException("not support limitType:" + plan.getLimitType());
            }
        }
    }

    private static String handleList(String performerValueStaff) {
        if (performerValueStaff == null) {
            return "";
        }
        CharSequence[] emails = performerValueStaff.replace("[", "").replace("]", "").replace("\"", "").split(",");
        return String.join((CharSequence)",", emails);
    }

    public void attributeAndLang(Map<String, Object> content, MechanismVariable variable, String attributeName, String suffix) {
        MultiLanguageDTO description = null == variable.getDescriptionLang() ? new MultiLanguageDTO() : variable.getDescriptionLang();
        description.setEn_US((StringUtils.isEmpty((CharSequence)description.getEn_US()) ? variable.getName() : description.getEn_US()) + suffix);
        description.setZh_CN((StringUtils.isEmpty((CharSequence)description.getZh_CN()) ? variable.getName() : description.getZh_CN()) + suffix);
        description.setZh_TW((StringUtils.isEmpty((CharSequence)description.getZh_TW()) ? variable.getName() : description.getZh_TW()) + suffix);
        if (content.containsKey("lang")) {
            Map lang = (Map)content.get("lang");
            lang.put(attributeName, description);
            content.put("lang", lang);
        } else {
            content.put("lang", ImmutableMap.of((Object)attributeName, (Object)description));
        }
        content.put(attributeName, variable.getName() + suffix);
    }

    private String apiData(LimitPlan plan, boolean relationScript) {
        String apiData = MechanismPlanType.reminderPlan.name().equals(plan.getType()) ? "data.data" : (relationScript ? "apiData" : "data");
        return apiData;
    }
}

