/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler;

import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitCommonUtil;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitHandler;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.config.RuleTrigger;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import com.digiwin.athena.mechanism.widgets.plan.LimitTaskActionPlan;
import com.digiwin.athena.preset.Rule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LimitTaskActionHandler
extends LimitCommonUtil
implements LimitHandler {
    private static final Logger log = LoggerFactory.getLogger(LimitTaskActionHandler.class);
    @Autowired
    PresetLibraryService presetLibraryService;

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.limitTaskActionPlan.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        List<Rule> rules = this.buildRules(singleStrategyWidget, parseContext);
        for (Rule rule : rules) {
            this.presetLibraryService.saveRule(rule);
        }
    }

    private List<Rule> buildRules(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        LimitTaskActionPlan limitTaskActionPlan = this.mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(), LimitTaskActionPlan.class);
        ArrayList<Rule> list = new ArrayList<Rule>();
        for (MechanismConditionConfig condition : limitTaskActionPlan.getConditions()) {
            Rule rule = new Rule();
            HashMap<String, Object> content = new HashMap<String, Object>();
            rule.setContent(content);
            this.ruleCommonSet(parseContext, rule);
            RuleContent ruleContent = limitTaskActionPlan.getRuleContent();
            RuleTrigger trigger = ruleContent.getTrigger();
            String limitType = condition.getLimitType();
            if (null != condition.getLeft().getPath()) {
                String fullPath = condition.getLeft().getPath();
                int len = fullPath.lastIndexOf(".");
                content.put("path", fullPath.substring(0, len));
                content.put("schema", fullPath.substring(len + 1));
            }
            switch (limitType) {
                case "required": {
                    content.put("key", "required");
                    trigger.setPoint("default");
                    content.put("validatorType", "error");
                    this.attributeAndLang(content, condition.getLeft(), "errorMessage", "\u5fc5\u586b");
                    if (!limitTaskActionPlan.getIsAsync().booleanValue()) break;
                    content.put("checkEmptyForAsyncRequired", true);
                    break;
                }
                case "hidden": {
                    content.put("key", "hidden");
                    trigger.setPoint("default");
                    break;
                }
                case "disabled": {
                    content.put("key", "disabled");
                    trigger.setPoint("default");
                    break;
                }
                case "scopeLimit": {
                    content.put("key", "scopeLimit");
                    break;
                }
            }
            content.put("trigger", trigger);
            content.put("description", "limitTaskAction");
            HashSet<DynamicFunction> dynamicFunctions = new HashSet<DynamicFunction>();
            StringBuilder sb = new StringBuilder();
            ArrayList<String> expressionList = new ArrayList<String>();
            this.expression(singleStrategyWidget, (LimitPlan)limitTaskActionPlan, parseContext, dynamicFunctions, expressionList);
            String expression = String.join((CharSequence)" && ", expressionList);
            sb.append(expression);
            String functionExp = this.jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
            if (null != functionExp) {
                sb.insert(0, functionExp);
            }
            if (limitTaskActionPlan.getIsAsync().booleanValue()) {
                trigger.setCondition(sb.toString());
            } else {
                content.put("condition", sb.toString());
            }
            list.add(rule);
        }
        return list;
    }
}

