/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitCommonUtil;
import com.digiwin.athena.datamap.mechanism.limithandler.LimitHandler;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.datamap.spi.PresetLibraryService;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.mechanismEnum.LimitEnum;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.RuleContent;
import com.digiwin.athena.mechanism.widgets.plan.LimitPlan;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import com.digiwin.athena.preset.Rule;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ReminderLimitHandler
extends LimitCommonUtil
implements LimitHandler {
    @Autowired
    PresetLibraryService presetLibraryService;
    @Autowired
    DataMapKgService dataMapKgService;

    @Override
    public boolean accept(SingleStrategyWidget singleStrategyWidget) {
        return singleStrategyWidget.getPositiveTarget() != null && MechanismPlanType.reminderPlan.name().equalsIgnoreCase(singleStrategyWidget.getPositiveTarget().getType());
    }

    @Override
    public void handler(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        Rule rule = this.buildRule(singleStrategyWidget, parseContext);
        this.presetLibraryService.saveRule(rule);
    }

    private Rule buildRule(SingleStrategyWidget singleStrategyWidget, MechanismParseContext parseContext) throws Exception {
        ReminderPlan reminderPlan = this.mechanismHelpService.convert(singleStrategyWidget.getPositiveTarget(), ReminderPlan.class);
        Rule rule = new Rule();
        HashMap<String, Object> content = new HashMap<String, Object>();
        rule.setContent(content);
        this.ruleCommonSet(parseContext, rule);
        content.put("description", "limitTaskAction");
        content.put("errorMessage", reminderPlan.getMessage());
        content.put("lang", this.handleLang(reminderPlan.getLang()));
        RuleContent ruleContent = reminderPlan.getRuleContent();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        String operationType = !ObjectUtils.isEmpty((Object)sourceWidget.getOperationType()) ? sourceWidget.getOperationType() : (String)sourceWidget.getOperationTypes().get(0);
        content.put("targetScope", "page");
        if (!"open".equals(operationType)) {
            content.put("targetScope", "operation");
            content.put("targetType", operationType);
        }
        content.put("key", "api-trigger");
        HashSet<DynamicFunction> dynamicFunctions = new HashSet<DynamicFunction>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> expressionList = new ArrayList<String>();
        this.expression(singleStrategyWidget, (LimitPlan)reminderPlan, parseContext, dynamicFunctions, expressionList);
        if (LimitEnum.mechanismParameter.equals((Object)reminderPlan.getMessageType())) {
            expressionList.add("mechanismParameter");
            dynamicFunctions.add(DynamicFunction.builder().functionName("mechanismParameter").parameter((Map<String, String>)ImmutableMap.of((Object)"parameter1", (Object)String.valueOf(reminderPlan.getMessage()))).build());
            this.addMechanismParameter(parseContext, reminderPlan.getMessage().toString());
        }
        String expression = String.join((CharSequence)" && ", expressionList);
        sb.append("if(").append(expression).append("){");
        String functionExp = this.jsExpressionConverter.dynamicFunctionExpression(dynamicFunctions);
        if (null != functionExp) {
            sb.insert(0, functionExp);
        }
        List variables = reminderPlan.getVariables();
        if (LimitEnum.mechanismParameter.equals((Object)reminderPlan.getMessageType())) {
            sb.append("const oDoctorReminder = {'list': [{'msg': ").append("dynamicMechanismParameter").append("}]};$nlpMessage.next(oDoctorReminder);}");
        } else {
            Map msgLangMap = reminderPlan.getLang() != null && reminderPlan.getLang().containsKey("message") ? (Map)reminderPlan.getLang().get("message") : this.initLangMsgMap(reminderPlan.getMessage());
            Map<String, String> langMap = ReminderLimitHandler.handleODoctorReminder(variables, reminderPlan, msgLangMap);
            sb.append("var processLocale = sessionStorage.getItem('language'); ").append("var msg = processLocale === 'zh_TW' ? '").append(langMap.get("zh_TW")).append("': processLocale === 'en_US' ? '").append(langMap.get("en_US")).append("':'").append(langMap.get("zh_CN")).append("'; ").append("const oDoctorReminder = {'list': [{'msg': msg}]};$nlpMessage.next(oDoctorReminder);}");
        }
        if (null != ruleContent) {
            ruleContent.getTrigger().setCondition(sb.toString());
            content.putAll((Map<String, Object>)JSON.parseObject((String)JSON.toJSONString((Object)ruleContent)));
        }
        content.put("condition", sb.toString());
        return rule;
    }

    private Map<String, String> initLangMsgMap(Object message) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (message == null) {
            result.put("zh_CN", "");
            result.put("zh_TW", "");
            result.put("en_US", "");
            return result;
        }
        String msg = message.toString();
        result.put("zh_CN", msg);
        result.put("zh_TW", msg);
        result.put("en_US", msg);
        return result;
    }

    private Map<String, Map<String, String>> handleLang(Map<String, Map<String, String>> lang) {
        if (lang == null) {
            return Collections.emptyMap();
        }
        if (lang.containsKey("message")) {
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            result.put("errorMessage", lang.get("message"));
            result.putAll(lang);
            return result;
        }
        return lang;
    }

    private static Map<String, String> handleODoctorReminder(List<MechanismVariable> variables, ReminderPlan reminderPlan, Map<String, String> msgLangMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(variables)) {
            result.putAll(msgLangMap);
            return result;
        }
        for (Map.Entry<String, String> entry : msgLangMap.entrySet()) {
            result.put(entry.getKey(), ReminderLimitHandler.handleVariables(variables, entry.getValue()));
        }
        return result;
    }

    private static String handleVariables(List<MechanismVariable> variables, Object message) {
        String mes = String.valueOf(message);
        ArrayList<String> sbList = new ArrayList<String>();
        variables.sort(Comparator.comparingInt(MechanismVariable::getIndex));
        Map indexMap = variables.stream().collect(Collectors.toMap(MechanismVariable::getIndex, Function.identity(), (a, b) -> b));
        int startIndex = 0;
        for (Map.Entry entry : indexMap.entrySet()) {
            Integer index = entry.getKey();
            MechanismVariable variable = (MechanismVariable)entry.getValue();
            String path = variable.getPath();
            String[] split = path.split("\\.");
            String rep = "taskData." + split[0] + "[0]." + variable.getData_name();
            sbList.add("'" + mes.substring(startIndex, index) + "'");
            sbList.add(rep);
            startIndex = index + 1;
        }
        sbList.add("'" + mes.substring(startIndex) + "'");
        return StringUtils.join(sbList, (String)"+");
    }
}

