/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction.LimitActionParser;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.condition.AutoProcessCondition;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DatamapAutoProcessParser
implements LimitActionParser {
    private static final Logger log = LoggerFactory.getLogger(DatamapAutoProcessParser.class);
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    DataMapKgService dataMapKgService;
    @Autowired
    ConditionParser conditionParser;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitActionType.AUTO_PROCESS.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Object parse(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        LimitAbilityBo bo = this.mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        List scenes = bo.getAutoProcess().getScenes();
        if (CollectionUtils.isEmpty((Collection)scenes)) {
            return null;
        }
        ArrayList result = new ArrayList();
        scenes.stream().forEach(v -> {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Boolean isSameLineReplace = ObjectUtils.isEmpty((Object)v.getSourceFieldConfig().getIsSameLineReplace()) ? Boolean.FALSE : v.getSourceFieldConfig().getIsSameLineReplace();
            Object sourceField = this.parseFieldConfig(v.getSourceFieldConfig(), apiInfoDTO, v.getSourceFieldConfig().getGroups(), true);
            Object targetField = this.parseFieldConfig(v.getTargetFieldConfig(), apiInfoDTO, v.getTargetFieldConfig().getGroups(), false);
            dataMap.put("type", v.getSourceFieldConfig().getRightCondType());
            dataMap.put("value", v.getSourceFieldConfig().getValue());
            dataMap.put("sourceField", sourceField);
            if (isSameLineReplace.booleanValue()) {
                JSONObject sourceJsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)sourceField));
                JSONObject targetJsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)targetField));
                sourceJsonObject.put("fields", (Object)targetJsonObject.getJSONArray("fields"));
                dataMap.put("targetField", sourceJsonObject);
            } else {
                dataMap.put("targetField", targetField);
            }
            result.add(dataMap);
        });
        return result;
    }

    private Object parseFieldConfig(AutoProcessCondition fieldConfig, MechanismApiInfoDTO apiInfoDTO, List<MechanismConditionGroup> groups, Boolean isSingle) {
        HashMap result = new HashMap();
        result.put("fields", fieldConfig.getFields().stream().map(v -> v.getData_name()).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(groups)) {
            if (ObjectUtils.isEmpty((Object)apiInfoDTO.getTableData())) {
                log.error("\u65e0\u8868\u683c\u6570\u636e\uff0c\u5165\u53c2\uff1a{}", (Object)apiInfoDTO);
                return null;
            }
            JSONArray metaDataList = JSON.parseArray((String)JSON.toJSONString((Object)apiInfoDTO.getTableData()));
            HashMap<String, Object> accordTableDataMap = new HashMap<String, Object>();
            accordTableDataMap.putAll(this.conditionParser.parseSingleScene(groups, metaDataList, apiInfoDTO, null));
            JSONArray accordTableDataArray = JSONArray.parseArray((String)JSON.toJSONString(accordTableDataMap.values()));
            log.info("parseFieldConfig\uff0caccordTableDataArray\uff1a{}", (Object)JSON.toJSONString((Object)accordTableDataArray));
            ArrayList rowDataList = accordTableDataArray.stream().map(v -> {
                JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)v));
                Object rowData = jsonObject.get((Object)"row_data");
                return rowData;
            }).collect(Collectors.toList());
            result.put("row_data", isSingle.booleanValue() ? (CollectionUtils.isEmpty(rowDataList) ? null : Lists.newArrayList((Object[])new Object[]{rowDataList.get(0)})) : rowDataList);
        }
        if (isSingle.booleanValue() && MechanismEnum.RightCondType.MECHANISM_VARIABLE.getCode().equalsIgnoreCase(fieldConfig.getRightCondType())) {
            ArrayList variableIds = Lists.newArrayList((Object[])new String[]{fieldConfig.getValue()});
            Object variableObj = this.dataMapKgService.getVariableListSimple(variableIds, Boolean.TRUE);
            JSONObject variableJsonObj = JSONObject.parseObject((String)JSON.toJSONString((Object)variableObj));
            fieldConfig.setValue(variableJsonObj.get((Object)fieldConfig.getValue()).toString());
        }
        return result;
    }
}

