/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.relation.Api;
import com.digiwin.athena.datamap.povo.UriRequest;
import com.digiwin.athena.datamap.service.IConfigService;
import com.digiwin.athena.datamap.service.inner.SelectService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.definition.EocUnit;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.v1.summary.Plan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@MyExceptionHandler
@Service
public class ConfigService
implements IConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigService.class);
    private static final String prefix = "config://";
    protected static final Map<String, Class<?>> configMap = new HashMap();
    @Autowired
    SelectService selectService;

    public ConfigService() {
        configMap.put("data", DataDescription.class);
        configMap.put("project", Project.class);
        configMap.put("plan", Plan.class);
        configMap.put("task", Task.class);
        configMap.put("activity", Activity.class);
        configMap.put("flow", FlowGraph.class);
        configMap.put("api", Api.class);
        configMap.put("eocUnit", EocUnit.class);
    }

    @Override
    public Object postConfig(UriRequest request) throws DWException {
        Assert.notNull((Object)request.getUri(), (String)"uri is null");
        String uri = request.getUri();
        if (!uri.startsWith(prefix)) {
            throw new DWArgumentException(uri, I18nUtils.getValue((String)"datamap.config.uriError", (Object[])new Object[0]));
        }
        URI uri0 = URI.create(uri);
        String table = uri0.getHost();
        String path = uri0.getPath();
        Class<?> c = configMap.get(table);
        if (null == c) {
            return null;
        }
        path = null != path ? path.replaceAll("/", ".") : ".";
        path = "$" + path;
        String query = uri0.getQuery();
        Map<String, Object> q = ConfigService.qtm(query);
        request.setQuery(q);
        List matched = this.selectService.allMatched(q, c, table);
        List root = null;
        if (request.isAllMatch()) {
            root = matched;
        } else if (matched.size() > 0) {
            root = matched.get(0);
        }
        Object value = JSONPath.eval((Object)root, (String)path);
        return value;
    }

    @Override
    public Map<String, Object> postConfigBatch(UriRequest request) throws DWException {
        HashMap<String, Object> results = new HashMap<String, Object>();
        request.getUris().forEach((k, v) -> {
            request.setUri((String)v);
            try {
                Object value = this.postConfig(request);
                results.put((String)k, value);
            }
            catch (DWException e) {
                log.error(e.toString());
            }
        });
        return results;
    }

    public static void main(String[] args) {
        String uri = "config://task/name/axf/sfs?id=123&type=2";
        URI uri0 = URI.create(uri);
        System.out.println(uri0.getHost());
        System.out.println(uri0.getPath());
        System.out.println(uri0.getQuery());
        System.out.println(ConfigService.qtm(uri0.getQuery()));
        System.out.println(uri0.getPath().replaceAll("/", "."));
    }

    public static Map<String, Object> qtm(String query) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (null != query) {
            String[] items;
            for (String item : items = query.split("&")) {
                String[] kv = item.split("=");
                if (kv.length <= 1) continue;
                m.put(kv[0], kv[1]);
            }
        }
        return m;
    }
}

