/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionHandler;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.kg.ActionMetadataDTOConvertor;
import com.digiwin.athena.datamap.service.IActionService;
import com.digiwin.athena.datamap.service.IMechanismService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kmservice.action.execution.ProductNameGetter;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@MyExceptionHandler
@Service
public class DataMapActionService
implements IActionService {
    private static final Logger log = LoggerFactory.getLogger(DataMapActionService.class);
    @Autowired
    List<ActionHandler> actionHandlers;
    @Autowired
    IMechanismService mechanismService;
    @Autowired
    KmService kmService;
    @Autowired
    ActionMetadataManager actionMetadataManager;
    @Autowired
    ProductNameResolver productNameResolver;

    @Override
    public ActionResp postProcess(ActionReq req) throws DWException {
        ActionResp resp = new ActionResp();
        ActionHandler handler = null;
        for (ActionHandler handler1 : this.actionHandlers) {
            if (!handler1.accept(req)) continue;
            handler = handler1;
            break;
        }
        if (null == handler) {
            throw new DWBusinessException("cant find ActionHandler by actionId:" + req.getActionId());
        }
        ActionContext context = new ActionContext();
        context.setActionReq(req);
        HttpServletRequest httpRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", null);
        String token = httpRequest.getHeader("token");
        if (null == token) {
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        }
        context.setTenantId(tenantId);
        context.setToken(token);
        String locale = httpRequest.getHeader("locale");
        context.setLocale(locale);
        try {
            resp = handler.handler(context);
        }
        catch (Exception e) {
            HashMap<String, JSONArray[]> rows = new HashMap<String, JSONArray[]>();
            rows.put("rows", new JSONArray[0]);
            resp.setData(rows);
            resp.setSuccess(Boolean.FALSE);
            log.error("req.getActionId():{},e:{}", (Object)req.getActionId(), (Object)e);
        }
        return resp;
    }

    @Override
    public ActionResp postProcess2(ActionReq req) throws DWException {
        return this.postProcess(req);
    }

    @Override
    public ActionResp judgeBusinessCondition(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        log.info("ActionService.judgeBusinessCondition beginning\uff0c\u5165\u53c2\u6709\uff1a{}", (Object)apiInfoDTO);
        ActionResp actionResp = new ActionResp();
        actionResp.setData(this.mechanismService.judgeBusinessCondition(apiInfoDTO));
        return actionResp;
    }

    @Override
    public Object getMetadata(String actionId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", "");
        String tenantVersion = this.kmService.tenantVersion();
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        EspActionMetadataDTO responseDTO = this.actionMetadataManager.getActionMetadata(actionId, tenantId, tenantVersion);
        GetActionLocaleResponseDTO localeResponseDTO = ActionMetadataDTOConvertor.convertToGetActionLocaleResponseDTO(responseDTO);
        ProductNameGetter.MdcProductNameGetter productNameGetter = null;
        if (actionId.startsWith("esp_")) {
            productNameGetter = new ProductNameGetter.MdcProductNameGetter(this.productNameResolver, actionId.substring(4), tenantId);
        }
        MetadataTranslator.translateField((GetActionLocaleResponseDTO)localeResponseDTO, (ActionMetadataDTO)responseDTO, (String)localeStr, productNameGetter);
        return localeResponseDTO;
    }
}

