/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.IBusinessService;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.kmservice.service.DataPickService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class DataMapBusinessService
implements IBusinessService {
    private static final Logger log = LoggerFactory.getLogger(DataMapBusinessService.class);
    @Autowired
    DataPickService dataPickService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;

    @Override
    public List<Project> postProjectExcludeMainlineByAppCode(String appCode) throws DWBusinessException {
        String version = this.dataPickService.tenantVersion();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"application").is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"executeType").ne((Object)"mainline").and("tenantId").is((Object)"SYSTEM").and("version").is((Object)version));
        return this.mongoTemplate.find(query, Project.class);
    }
}

