/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.datamap.service.IDictService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.utils.LanguageUtil;
import com.digiwin.athena.kg.dict.Dictionary;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
public class DataMapDictService
implements IDictService {
    private static final Logger log = LoggerFactory.getLogger(DataMapDictService.class);
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate sysMongoTemplate;
    @Autowired
    KmService kmService;

    @Override
    public Object getDictByKey(String key) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        log.info("getDictByKey locale:{}", (Object)locale);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)key).and("version").is((Object)tenantVersion));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"code")}));
        List dicts = this.sysMongoTemplate.find(query, Dictionary.class, "dictionary");
        try {
            LanguageUtil.processLocaleLanguage(dicts, locale);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return dicts;
    }

    @Override
    public Object getDictByKeyAndCode(String key, String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        log.info("getDictByKeyAndCode locale:{}", (Object)locale);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)key).and("code").is((Object)code).and("version").is((Object)tenantVersion));
        Dictionary dict = (Dictionary)this.sysMongoTemplate.findOne(query, Dictionary.class, "dictionary");
        try {
            LanguageUtil.processLocaleLanguage(dict, locale);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return dict;
    }

    @Override
    public Object postFindDictByKeyList(List<String> keyList) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.kmService.tenantVersion();
        if (CollectionUtils.isEmpty(keyList)) {
            return null;
        }
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        log.info("getDictByKeyList locale:{}", (Object)locale);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(keyList).and("version").is((Object)tenantVersion));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"key"), Sort.Order.asc((String)"code")}));
        List dicts = this.sysMongoTemplate.find(query, Dictionary.class, "dictionary");
        if (CollectionUtils.isEmpty((Collection)dicts)) {
            log.info("getDictByKeyList is null keys:{}", keyList);
            return null;
        }
        try {
            LanguageUtil.processLocaleLanguage(dicts, locale);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        Map<String, List<Dictionary>> collect = dicts.stream().collect(Collectors.groupingBy(Dictionary::getKey));
        return collect;
    }
}

