/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.IDutyService;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.spi.DatamapEocService;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.domain.Duty;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.repository.neo4j.DutyRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
public class DataMapDutyService
implements IDutyService {
    static Logger logger = LoggerFactory.getLogger(DataMapDutyService.class);
    static Log log = LogFactory.getLog(DataMapDutyService.class);
    @Autowired
    private DutyRepository repository;
    @Value(value="${hello1}")
    String hello1;
    @Value(value="${iamApToken}")
    String appToken;
    @Autowired
    DatamapAppService datamapAppService;
    @Autowired
    DatamapEocService datamapEocService;

    @Override
    public Object getDutyByCode(String code) {
        return this.repository.findOneByCode(code);
    }

    @Override
    public Object getList() {
        ArrayList dutyList = new ArrayList();
        this.repository.findAll().forEach(d -> dutyList.add(d));
        return dutyList;
    }

    @Override
    public Object syncAllDuty() throws DWBusinessException {
        List dutyList = (List)this.getList();
        boolean count = false;
        for (Duty d : dutyList) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("id", d.getCode());
            param.put("name", d.getName());
            param.put("modify", true);
            this.datamapEocService.syncDuty(param);
        }
        return null;
    }

    @Override
    public Object syncAllDuty(String token, String appCode, String tenantId) throws Exception {
        List dutyList = (List)this.getList();
        List<ApplicationRelation> applicationRelations = this.datamapAppService.getApplicationRelationByTypeAndAppCode("duty", appCode);
        List appDutyCodes = CollectionUtils.isEmpty(applicationRelations) ? Collections.EMPTY_LIST : applicationRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        for (Duty d : dutyList) {
            if (!appDutyCodes.contains(d.getCode())) continue;
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("id", d.getCode());
            param.put("name", d.getName());
            param.put("modify", true);
            this.datamapEocService.syncDuty(param);
        }
        return null;
    }

    @Override
    public Object syncAllDuty(String token) throws DWBusinessException {
        List dutyList = (List)this.getList();
        boolean count = false;
        for (Duty d : dutyList) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("id", d.getCode());
            param.put("name", d.getName());
            param.put("modify", true);
            this.datamapEocService.syncDuty(param);
        }
        return null;
    }

    @Override
    public Object getTest(String p) {
        return null;
    }
}

