/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.ITestService;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kmservice.analysis.AnalysisComponent;
import com.digiwin.athena.kmservice.analysis.AnalysisTool;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class DataMapTestService
implements ITestService {
    private static final Logger log = LoggerFactory.getLogger(DataMapTestService.class);
    @Value(value="${hello1}")
    private String hello1;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    LoggingSystem loggingSystem;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    DatamapAppService applicationService;
    @Autowired
    KmService kmService;
    @Autowired
    AnalysisComponent analysisComponent;

    public DataMapTestService() {
        System.out.println("TestService..........");
    }

    @Override
    public String getTest01(String input) {
        System.out.println("test1.....");
        Integer.parseInt("s");
        return "hello ";
    }

    @Override
    public Object postTest02(Map<String, Object> input) {
        System.out.println("test02...............");
        return input;
    }

    @Override
    public Object getTest_neo4j(String input) {
        Session session = this.sessionFactory.openSession();
        Result r = session.query("match(d:DataMapGraph) where d.key='DTD' return d.version", new HashMap());
        Map map = (Map)r.iterator().next();
        return map;
    }

    @Override
    public String getLogLevel(String level) {
        log.debug("debug");
        log.info("info");
        log.warn("warn");
        log.error("error");
        Level level1 = Level.toLevel((String)level);
        LogManager.getRootLogger().setLevel(level1);
        return level;
    }

    @Override
    public Object getTest04(String input) throws DWBusinessException {
        System.out.println("test4.....");
        return "permissions";
    }

    @Override
    public Object getTest05(String input) throws DWBusinessException {
        System.out.println("test5.....");
        Task task = (Task)this.dataPickService.findByCode(input, Task.class);
        return task;
    }

    @Override
    public String getRedisSet(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        return null;
    }

    @Override
    public String getRedisGet(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public String tenantId() {
        String tenantId = ServiceUtils.getTenantIdSilent();
        return tenantId;
    }

    @Override
    public Object getStatics(String input) {
        return this.analysisComponent.allAnalysisInfo();
    }

    @Override
    public Object getStack(String input) {
        return AnalysisTool.threadDump();
    }

    public static void main(String[] args) {
    }
}

