/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import com.digiwin.athena.datamap.povo.CardGroup;
import com.digiwin.athena.datamap.povo.CardGroupGroup;
import com.digiwin.athena.datamap.povo.ConditionScopeDTO;
import com.digiwin.athena.datamap.povo.SystemWSConditionVO;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.datamap.povo.WSConditionDTO;
import com.digiwin.athena.datamap.povo.WSConditionVO;
import com.digiwin.athena.datamap.povo.WorkbenchSetting;
import com.digiwin.athena.datamap.povo.WorkbenchSettingRequest;
import com.digiwin.athena.datamap.povo.WorkbenchSettingVO;
import com.digiwin.athena.datamap.service.IWorkbenchSettingService;
import com.digiwin.athena.datamap.service.impl.DataMapTaskFieldService;
import com.digiwin.athena.datamap.service.impl.DataMapViewService;
import com.digiwin.athena.datamap.spi.DatamapCacService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.service.KmGeneralService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@MyExceptionHandler
@Service
public class DataMapWorkbenchSettingService
implements IWorkbenchSettingService {
    private static final Logger log = LoggerFactory.getLogger(DataMapWorkbenchSettingService.class);
    @Autowired
    private IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    private DataMapTaskFieldService dataMapTaskFieldService;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    private DataMapViewService dataMapViewService;
    @Autowired
    private KmGeneralService kmGeneralService;
    @Autowired
    private DatamapCacService datamapCacService;

    @Override
    public WorkbenchSettingVO getWorkbenchSetting(WSPageCode pageCode, WSConfigType configType, Boolean appCondition) throws DWException {
        WorkbenchSettingVO workbenchSettingVO;
        String tenantId = ServiceUtils.getTenantId();
        if (pageCode == WSPageCode.task && configType == WSConfigType.groups) {
            Map aliasName;
            Map lang;
            workbenchSettingVO = new WorkbenchSettingVO();
            workbenchSettingVO.setTenantId(tenantId);
            workbenchSettingVO.setPageCode(pageCode);
            workbenchSettingVO.setConfigType(configType);
            ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<WSConditionVO>();
            CardGroup cardGroup = this.knowledgeGraphService.findOne(Filters.eq((String)"tenantId", (Object)tenantId), CardGroup.class, "cardGroup", KnowledgeGraphDb.TENANT);
            if (null == cardGroup) {
                List<CardGroupGroup> cardGroupGroups = this.dataMapTaskFieldService.sysCardGroups(tenantId);
                if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                    List<WSConditionVO> sysConditions = DataMapTaskFieldService.systemCardGroupGroupToCondition(cardGroupGroups);
                    wsConditionVOS.addAll(sysConditions);
                }
                if (Boolean.TRUE.equals(appCondition)) {
                    String tenantVersion = this.dataPickService.tenantVersion(tenantId);
                    List<String> authApps = this.datamapCacService.getAuthorizationsApplication(tenantId);
                    List<ApplicationRelation> taskRelations = this.knowledgeGraphService.find(Filters.and((Bson[])new Bson[]{Filters.in((String)"appCode", authApps), Filters.eq((String)"type", (Object)"activity"), Filters.eq((String)"version", (Object)tenantVersion)}), ApplicationRelation.class, "applicationRelation", KnowledgeGraphDb.SYSTEM);
                    List taskCodes = taskRelations.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
                    HashMap taskRelationsMap = new HashMap();
                    taskRelations.forEach(applicationRelation -> taskRelationsMap.put(applicationRelation.getCode(), applicationRelation));
                    ViewRequest viewRequest = new ViewRequest();
                    viewRequest.setQuery(MapUtil.of((Object)"code", taskCodes));
                    List<WSConditionDTO> appConditions = this.dataMapViewService.postNewCardConfig(viewRequest);
                    if (CollectionUtil.isNotEmpty(appConditions)) {
                        Map<String, List<WSConditionDTO>> conditionMap = appConditions.stream().collect(Collectors.groupingBy(WSConditionDTO::getAliasCode));
                        for (Map.Entry<String, List<WSConditionDTO>> entry : conditionMap.entrySet()) {
                            List<WSConditionDTO> conditionVOS = entry.getValue();
                            WSConditionDTO wsConditionVO = conditionVOS.stream().min(Comparator.comparing(WSConditionDTO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).get();
                            wsConditionVO.setAppCode(((ApplicationRelation)taskRelationsMap.get(wsConditionVO.getTaskCode())).getAppCode());
                            List<ConditionScopeDTO> scopeVOList = conditionVOS.stream().flatMap(v -> v.getConditionScope().stream()).distinct().sorted(Comparator.comparing(ConditionScopeDTO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeDTO::getId, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
                            for (ConditionScopeDTO conditionScopeVO : scopeVOList) {
                                ApplicationRelation applicationRelation2 = (ApplicationRelation)taskRelationsMap.get(conditionScopeVO.getCode());
                                if (applicationRelation2 == null) continue;
                                conditionScopeVO.setAppName(applicationRelation2.getAppName());
                                conditionScopeVO.setAppCode(applicationRelation2.getAppCode());
                            }
                            this.kmGeneralService.handleLang(scopeVOList);
                            wsConditionVO.setConditionScope(scopeVOList);
                            wsConditionVOS.add((WSConditionVO)((Object)this.dataPickService.convert((Object)wsConditionVO, WSConditionVO.class)));
                        }
                    }
                }
                List<WSConditionVO> defaultCondition = wsConditionVOS.stream().filter(v -> Boolean.TRUE.equals(v.getEnable())).map(v -> {
                    WSConditionVO wsConditionVO = (WSConditionVO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class)));
                    if (wsConditionVO.getSourceType() == SourceType.customer) {
                        wsConditionVO.setEnable(false);
                    }
                    return wsConditionVO;
                }).collect(Collectors.toList());
                workbenchSettingVO.setCondition(wsConditionVOS);
                workbenchSettingVO.setDefaultCondition(defaultCondition);
            } else {
                workbenchSettingVO = this.dataMapTaskFieldService.cardGroupToWSConditionVO(cardGroup);
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
                lang = wsConditionVO.getLang();
                if (lang == null || (aliasName = (Map)lang.get("aliasName")) != null) continue;
                wsConditionVO.setLang(MapUtil.of((Object)"aliasName", wsConditionVO.getLang().get("name")));
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getDefaultCondition()) {
                lang = wsConditionVO.getLang();
                if (lang == null || (aliasName = (Map)lang.get("aliasName")) != null) continue;
                wsConditionVO.setLang(MapUtil.of((Object)"aliasName", wsConditionVO.getLang().get("name")));
            }
            this.kmGeneralService.handleLang(workbenchSettingVO.getCondition());
            this.kmGeneralService.handleLang(workbenchSettingVO.getDefaultCondition());
        } else {
            WorkbenchSetting workbenchSetting = this.knowledgeGraphService.findOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"pageCode", (Object)pageCode.name()), Filters.eq((String)"configType", (Object)configType.name())}), WorkbenchSetting.class, "workbenchSetting", KnowledgeGraphDb.TENANT);
            workbenchSettingVO = workbenchSetting == null ? this.getCardSetting(pageCode, configType, appCondition) : (WorkbenchSettingVO)JSON.parseObject((String)JSON.toJSONString((Object)workbenchSetting), WorkbenchSettingVO.class);
            this.kmGeneralService.handleLang(workbenchSettingVO.getCondition());
            this.kmGeneralService.handleLang(workbenchSettingVO.getDefaultCondition());
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
                this.kmGeneralService.handleLang(wsConditionVO.getConditionScope());
            }
        }
        return workbenchSettingVO;
    }

    public WorkbenchSettingVO getCardSetting(WSPageCode pageCode, WSConfigType configType, Boolean appCondition) throws DWException {
        List<String> authApps;
        String tenantId;
        try {
            tenantId = ServiceUtils.getTenantId();
            authApps = this.datamapCacService.getAuthorizationsApplication(tenantId);
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setConfigType(configType);
        workbenchSettingVO.setPageCode(pageCode);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<WSConditionVO>();
        String tenantVersion = this.dataPickService.tenantVersion(tenantId);
        if (WSPageCode.task == pageCode) {
            if (WSConfigType.filter == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.taskFilterWSConditionVO);
            } else if (WSConfigType.order == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.taskOrderWSConditionVO);
            }
        } else if (WSPageCode.project == pageCode) {
            if (WSConfigType.groups == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectGroupWSConditionVO);
            } else if (WSConfigType.filter == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectFilterWSConditionVO);
            } else if (WSConfigType.order == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectOrderWSConditionVO);
            }
        }
        if (Boolean.TRUE.equals(appCondition)) {
            String type = null;
            if (WSPageCode.task == pageCode) {
                type = "activity";
            } else if (WSPageCode.project == pageCode) {
                type = "task";
            }
            List<ApplicationRelation> taskRelations = this.knowledgeGraphService.find(Filters.and((Bson[])new Bson[]{Filters.in((String)"appCode", authApps), Filters.eq((String)"type", (Object)type), Filters.eq((String)"version", (Object)tenantVersion)}), Projections.include((String[])new String[]{"code", "appName"}), ApplicationRelation.class, "applicationRelation", KnowledgeGraphDb.SYSTEM);
            if (CollectionUtil.isNotEmpty(taskRelations)) {
                HashMap applicationNameMap = new HashMap();
                taskRelations.forEach(applicationRelation -> applicationNameMap.put(applicationRelation.getCode(), applicationRelation));
                List<String> codeList = taskRelations.stream().map(v -> v.getCode()).distinct().collect(Collectors.toList());
                WorkbenchSettingRequest request = new WorkbenchSettingRequest();
                request.setCode(codeList);
                request.setConfigType(configType);
                request.setPageCode(pageCode);
                List<WSConditionDTO> customerConditionVOS = this.dataMapViewService.postWorkbenchSetting(request);
                if (!customerConditionVOS.isEmpty()) {
                    Map<String, List<WSConditionDTO>> conditionMap = customerConditionVOS.stream().collect(Collectors.groupingBy(v -> v.getAliasCode()));
                    for (Map.Entry<String, List<WSConditionDTO>> entry : conditionMap.entrySet()) {
                        WSConditionDTO wsConditionVO;
                        List<WSConditionDTO> wsConditionDTOS = entry.getValue();
                        if (wsConditionDTOS.size() > 1) {
                            wsConditionVO = wsConditionDTOS.stream().sorted(Comparator.comparing(WSConditionDTO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().get();
                            wsConditionVO.setConditionScope(wsConditionDTOS.stream().flatMap(v -> v.getConditionScope().stream()).distinct().sorted(Comparator.comparing(ConditionScopeDTO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeDTO::getId, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList()));
                            String dataType = null;
                            for (String s : Arrays.asList("boolean", "date", "select", "string", "number")) {
                                if (!wsConditionDTOS.stream().anyMatch(v -> s.equals(v.getDataType()))) continue;
                                dataType = s;
                                break;
                            }
                            if (dataType != null) {
                                wsConditionVO.setDataType(dataType);
                            }
                        } else {
                            wsConditionVO = wsConditionDTOS.get(0);
                        }
                        for (ConditionScopeDTO conditionScopeVO : wsConditionVO.getConditionScope()) {
                            ApplicationRelation applicationRelation2 = (ApplicationRelation)applicationNameMap.get(conditionScopeVO.getCode());
                            if (applicationRelation2 == null) continue;
                            conditionScopeVO.setAppCode(applicationRelation2.getAppCode());
                            conditionScopeVO.setAppName(applicationRelation2.getAppName());
                        }
                        wsConditionVOS.add((WSConditionVO)((Object)this.dataPickService.convert((Object)wsConditionVO, WSConditionVO.class)));
                    }
                }
            }
        }
        List<WSConditionVO> defaultCondition = wsConditionVOS.stream().filter(v -> Boolean.TRUE.equals(v.getEnable())).map(v -> {
            WSConditionVO wsConditionVO = (WSConditionVO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class)));
            if (wsConditionVO.getSourceType() == SourceType.customer) {
                wsConditionVO.setEnable(false);
            }
            return wsConditionVO;
        }).collect(Collectors.toList());
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        workbenchSettingVO.setCondition(wsConditionVOS);
        return workbenchSettingVO;
    }
}

