/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.ActionVO;
import com.digiwin.athena.datamap.povo.AppVO;
import com.digiwin.athena.datamap.povo.AuthorityConfigVoFromKg;
import com.digiwin.athena.datamap.povo.ConditionVO;
import com.digiwin.athena.datamap.povo.ModuleVO;
import com.digiwin.athena.datamap.service.IAuthorityService;
import com.digiwin.athena.datamap.service.IProjectService;
import com.digiwin.athena.datamap.spi.DatamapGMCService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.locale.Lang;
import com.mongodb.client.model.Filters;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Lang
@MyExceptionHandler
@Service
public class DatamapAuthorityService
implements IAuthorityService {
    private static final String START_PROJECT_CODE = "startProject";
    private static final String START_PROJECT_NAME = "\u53d1\u8d77\u9879\u76ee";
    private static final Logger log = LoggerFactory.getLogger(DatamapAuthorityService.class);
    @Autowired
    private IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    private IProjectService projectService;
    @Autowired
    private DatamapGMCService datamapGmcService;

    @Override
    public Object postStartProjectAuthorityByAppCode(String appCode) throws Exception {
        List<Project> taskList = this.knowledgeGraphService.find(Filters.eq((String)"authorityPrefix", (Object)(appCode + ":" + START_PROJECT_CODE)), Project.class, "taskConfigs", KnowledgeGraphDb.SYSTEM);
        ArrayList<Project> projects = new ArrayList<Project>(taskList);
        try {
            List<Project> datamapTasks = this.projectService.getProjectByAuthorityPrefix(appCode + ":" + START_PROJECT_CODE);
            if (!CollectionUtils.isEmpty(datamapTasks)) {
                projects.addAll(taskList);
            }
        }
        catch (Exception e) {
            log.error("getProjectByAuthorityPrefix error", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(projects)) {
            throw new DWBusinessException("\u6ca1\u627e\u5230\u9700\u8981\u751f\u6210\u6743\u9650\u7684\u53d1\u8d77\u9879\u76ee\u4fe1\u606f");
        }
        AuthorityConfigVoFromKg configVO = this.generateToStartProjectAuthorityConfig(appCode, null, projects);
        return this.postGenerateAuthority(configVO);
    }

    private AuthorityConfigVoFromKg generateToStartProjectAuthorityConfig(String appCode, String appName, List<Project> taskList) {
        AuthorityConfigVoFromKg configVO = new AuthorityConfigVoFromKg();
        AppVO app = new AppVO();
        app.setId(appCode);
        app.setName(StringUtils.isEmpty((CharSequence)appName) ? appCode : appName);
        configVO.setApp(app);
        configVO.setType("UPDATE");
        ArrayList<ModuleVO> moduleVOList = new ArrayList<ModuleVO>();
        ModuleVO moduleVO = new ModuleVO();
        moduleVO.setId(START_PROJECT_CODE);
        moduleVO.setName(START_PROJECT_NAME);
        moduleVOList.add(moduleVO);
        configVO.setModules(moduleVOList);
        ArrayList<ActionVO> actionVOList = new ArrayList<ActionVO>();
        for (Project task : taskList) {
            ActionVO actionVO = new ActionVO();
            actionVO.setId(task.getCode());
            actionVO.setModuleId(START_PROJECT_CODE);
            actionVO.setName(task.getName());
            ArrayList<ConditionVO> conditionVOList = new ArrayList<ConditionVO>();
            ConditionVO conditionVO = new ConditionVO();
            conditionVO.setKey("enable");
            conditionVO.setName("\u9879\u76ee\u542f\u7528");
            conditionVO.setTypeParameter(this.getTypeParameter());
            conditionVO.setDefaultValue(this.getTypeParameter().get(0));
            conditionVOList.add(conditionVO);
            actionVO.setCondition(conditionVOList);
            actionVOList.add(actionVO);
        }
        configVO.setActions(actionVOList);
        return configVO;
    }

    private List<String> getTypeParameter() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("allow");
        result.add("forbidden");
        return result;
    }

    private Object postGenerateAuthority(AuthorityConfigVoFromKg config) throws Exception {
        log.info("GenerateAuthority config:{}", (Object)JSON.toJSONString((Object)config));
        this.check(config);
        Object cloudGood = this.datamapGmcService.getCloudGood(config.getApp().getId());
        if (cloudGood == null) {
            throw new DWBusinessException("\u6ca1\u6709\u67e5\u5230\u5546\u54c1\u4fe1\u606f:" + config.getApp().getId());
        }
        JSONObject goodObj = JSON.parseObject((String)JSON.toJSONString((Object)cloudGood));
        log.info("getCloudGood:{}", (Object)goodObj);
        JSONObject modules = goodObj.getJSONObject("modules");
        if (modules == null || StringUtils.isEmpty((CharSequence)modules.getString("appToken")) && StringUtils.isEmpty((CharSequence)config.getAppToken())) {
            throw new DWBusinessException("appToken\u7f3a\u5931");
        }
        this.upsertAuthorityConfig(goodObj, config);
        log.info("toUpdateGoodsInfo:{}", (Object)goodObj);
        Object updateCloudGoodModulesRequestObj = this.getUpdateCloudGoodModulesRequestObj(goodObj);
        Object updateCloudGoodModulesResultObj = this.datamapGmcService.updateCloudGoodModules(updateCloudGoodModulesRequestObj);
        JSONObject updateCloudGoodModulesResult = JSON.parseObject((String)JSON.toJSONString((Object)updateCloudGoodModulesResultObj));
        if (!updateCloudGoodModulesResult.getBoolean("success").booleanValue()) {
            throw new DWBusinessException(String.format("\u5546\u54c1(%s)\u66f4\u65b0\u6a21\u7ec4\u4fe1\u606f\u5931\u8d25", config.getApp().getId()));
        }
        return "success";
    }

    private void check(AuthorityConfigVoFromKg config) throws Exception {
        if (config == null) {
            throw new DWBusinessException("\u6743\u9650\u914d\u7f6e\u4fe1\u606f\u7f3a\u5931");
        }
        AppVO app = config.getApp();
        if (app == null || StringUtils.isEmpty((CharSequence)app.getId()) || StringUtils.isEmpty((CharSequence)app.getName())) {
            throw new DWBusinessException("appId\u6216\u8005name\u4fe1\u606f\u7f3a\u5931");
        }
        if (!("ADD".equals(config.getType()) || "UPDATE".equals(config.getType()) || "DELETE_MODULE".equals(config.getType()) || "DELETE_ACTION".equals(config.getType()) || "DELETE_CONDITION".equals(config.getType()))) {
            throw new DWBusinessException("type\u7c7b\u578b\u9519");
        }
        if ("ADD".equals(config.getType()) || "UPDATE".equals(config.getType())) {
            List<ModuleVO> modules = config.getModules();
            if (CollectionUtils.isEmpty(modules)) {
                throw new DWBusinessException("modules\u4e3a");
            }
            for (ModuleVO e : modules) {
                if (!StringUtils.isEmpty((CharSequence)e.getId()) && !StringUtils.isEmpty((CharSequence)e.getName())) continue;
                throw new DWBusinessException("module\u4fe1\u606f\u7f3a\u5931");
            }
            List<ActionVO> actions = config.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                throw new DWBusinessException("actions\u4e3a\u7a7a");
            }
            for (ActionVO actionVO : actions) {
                if (StringUtils.isEmpty((CharSequence)actionVO.getId()) || StringUtils.isEmpty((CharSequence)actionVO.getName())) {
                    throw new DWBusinessException("action\u4fe1\u606f\u7f3a\u5931");
                }
                if (StringUtils.isEmpty((CharSequence)actionVO.getModuleId())) {
                    throw new DWBusinessException("action\u4e2dmoduleId\u4fe1\u606f\u4e3a\u7a7a");
                }
                if (CollectionUtils.isEmpty(actionVO.getCondition())) {
                    throw new DWBusinessException("action\u4e2dCondition\u4fe1\u606f\u4e3a\u7a7a");
                }
                for (ConditionVO conditionVO : actionVO.getCondition()) {
                    if (StringUtils.isEmpty((CharSequence)conditionVO.getKey())) {
                        throw new DWBusinessException("condition\u4e2dkey\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)conditionVO.getName())) {
                        throw new DWBusinessException("condition\u4e2dname\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)conditionVO.getDefaultValue())) {
                        throw new DWBusinessException("condition\u4e2ddefaultValue\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (CollectionUtils.isEmpty(conditionVO.getTypeParameter())) {
                        throw new DWBusinessException("condition\u4e2dtypeParameter\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (conditionVO.getTypeParameter().contains(conditionVO.getDefaultValue())) continue;
                    throw new DWBusinessException("condition\u4e2ddefaultValue\u4e0d\u5728typeParameter\u96c6\u5408\u4e2d");
                }
            }
        }
    }

    private void upsertAuthorityConfig(JSONObject sourceObj, AuthorityConfigVoFromKg config) {
        this.makeUpConfig(config);
        JSONObject modules = sourceObj.getJSONObject("modules");
        if (modules == null) {
            JSONObject configObj = JSON.parseObject((String)JSON.toJSONString((Object)config));
            configObj.remove((Object)"type");
            sourceObj.put("modules", (Object)configObj);
        } else if ("ADD".equals(config.getType())) {
            modules.put("modules", (Object)JSONArray.parseArray((String)JSON.toJSONString(config.getModules())));
            modules.put("actions", (Object)JSONArray.parseArray((String)JSON.toJSONString(config.getActions())));
        } else if ("UPDATE".equals(config.getType())) {
            JSONArray modulesArray = modules.getJSONArray("modules");
            Map<String, List<ModuleVO>> collect = config.getModules().stream().collect(Collectors.groupingBy(e -> e.getId()));
            ArrayList moduleToAddList = new ArrayList();
            for (int i = 0; i < modulesArray.size(); ++i) {
                JSONObject jsonObject = modulesArray.getJSONObject(i);
                String moduleId = jsonObject.getString("id");
                if (!CollectionUtils.isEmpty((Collection)collect.get(moduleId))) {
                    jsonObject.put("name", (Object)collect.get(moduleId).get(0).getName());
                }
                collect.remove(moduleId);
            }
            for (Map.Entry<String, List<ModuleVO>> entry : collect.entrySet()) {
                moduleToAddList.addAll(entry.getValue());
            }
            if (!CollectionUtils.isEmpty(moduleToAddList)) {
                modulesArray.addAll(moduleToAddList);
            }
            JSONArray actionsArray = modules.getJSONArray("actions");
            Map<String, List<ActionVO>> collect1 = config.getActions().stream().collect(Collectors.groupingBy(e -> e.getId() + "###" + e.getModuleId()));
            ArrayList actionsToAddList = new ArrayList();
            for (int i = 0; i < actionsArray.size(); ++i) {
                JSONObject jsonObject = actionsArray.getJSONObject(i);
                String actionBelongModuleId = jsonObject.getString("moduleId");
                String actionId = jsonObject.getString("id");
                List<ActionVO> removeAction = collect1.remove(actionId + "###" + actionBelongModuleId);
                if (CollectionUtils.isEmpty(removeAction)) continue;
                ActionVO actionVo = removeAction.get(0);
                jsonObject.put("name", (Object)actionVo.getName());
                JSONArray conditionArray = jsonObject.getJSONArray("condition");
                ArrayList conditionsToAddList = new ArrayList();
                Map<String, List<ConditionVO>> collect2 = removeAction.get(0).getCondition().stream().collect(Collectors.groupingBy(e -> e.getKey()));
                for (int j = 0; j < conditionArray.size(); ++j) {
                    JSONObject conditionObj = conditionArray.getJSONObject(j);
                    String conditionKey = conditionObj.getString("key");
                    List<ConditionVO> removeCondition = collect2.remove(conditionKey);
                    if (CollectionUtils.isEmpty(removeCondition)) continue;
                    ConditionVO conditionVO = removeCondition.get(0);
                    conditionObj.put("name", (Object)conditionVO.getName());
                    conditionObj.put("type", (Object)conditionVO.getType());
                    conditionObj.put("typeParameter", conditionVO.getTypeParameter());
                    conditionObj.put("parameter", (Object)conditionVO.getParameter());
                    conditionObj.put("defaultValue", (Object)conditionVO.getDefaultValue());
                }
                for (Map.Entry<String, List<ConditionVO>> entry : collect2.entrySet()) {
                    conditionsToAddList.addAll(entry.getValue());
                }
                if (CollectionUtils.isEmpty(conditionsToAddList)) continue;
                conditionArray.addAll(conditionsToAddList);
            }
            for (Map.Entry<String, List<ActionVO>> entry : collect1.entrySet()) {
                actionsToAddList.addAll(entry.getValue());
            }
            if (!CollectionUtils.isEmpty(actionsToAddList)) {
                actionsArray.addAll(actionsToAddList);
            }
        } else if ("DELETE_MODULE".equals(config.getType())) {
            this.deleteModule(modules, config);
        } else if ("DELETE_ACTION".equals(config.getType())) {
            this.deleteAction(modules, config);
        } else if ("DELETE_CONDITION".equals(config.getType())) {
            this.deleteCondition(modules, config);
        }
    }

    private void makeUpConfig(AuthorityConfigVoFromKg config) {
        String id = config.getApp().getId();
        config.getApp().setCategoryId(id);
        config.getApp().setIdFirst(id);
        for (ActionVO actionVO : config.getActions()) {
            String name = actionVO.getName();
            String actionVOId = actionVO.getId();
            for (ConditionVO conditionVO : actionVO.getCondition()) {
                conditionVO.setSid(this.getSid());
                conditionVO.setType("single");
                conditionVO.setParameter(JSON.toJSONString(conditionVO.getTypeParameter()));
                conditionVO.setActionName(name);
                conditionVO.setActionId(actionVOId);
            }
        }
    }

    private static String getSid() {
        StringBuilder sb = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        for (int i = 0; i < 16; ++i) {
            sb.append(rd.nextInt(10));
        }
        return sb.toString();
    }

    private void deleteModule(JSONObject modules, AuthorityConfigVoFromKg config) {
        JSONArray actionsArray;
        List<ModuleVO> configModules = config.getModules();
        if (CollectionUtils.isEmpty(configModules)) {
            return;
        }
        Set configModuleIdSet = configModules.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getId())).map(ModuleVO::getId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(configModuleIdSet)) {
            return;
        }
        JSONArray modulesArray = modules.getJSONArray("modules");
        if (!ObjectUtils.isEmpty((Object)modulesArray)) {
            Iterator iterator = modulesArray.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(next));
                if (jsonObject == null || !configModuleIdSet.contains(jsonObject.getString("id"))) continue;
                iterator.remove();
            }
        }
        if (!ObjectUtils.isEmpty((Object)(actionsArray = modules.getJSONArray("actions")))) {
            Iterator iterator = actionsArray.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(next));
                if (jsonObject == null || !configModuleIdSet.contains(jsonObject.getString("moduleId"))) continue;
                iterator.remove();
            }
        }
    }

    private void deleteAction(JSONObject modules, AuthorityConfigVoFromKg config) {
        List<ActionVO> configActions = config.getActions();
        if (CollectionUtils.isEmpty(configActions)) {
            return;
        }
        Set configModuleAndActionIdSet = configActions.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getId()) && StringUtils.isNotEmpty((CharSequence)e.getModuleId())).map(e -> e.getModuleId() + "###" + e.getId()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(configModuleAndActionIdSet)) {
            return;
        }
        JSONArray actionsArray = modules.getJSONArray("actions");
        if (!ObjectUtils.isEmpty((Object)actionsArray)) {
            Iterator iterator = actionsArray.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(next));
                if (jsonObject == null || !configModuleAndActionIdSet.contains(jsonObject.getString("moduleId") + "###" + jsonObject.getString("id"))) continue;
                iterator.remove();
            }
        }
    }

    private void deleteCondition(JSONObject modules, AuthorityConfigVoFromKg config) {
        List<ActionVO> configActions = config.getActions();
        if (CollectionUtils.isEmpty(configActions)) {
            return;
        }
        Map<String, List<ActionVO>> collect1 = configActions.stream().collect(Collectors.groupingBy(e -> e.getModuleId() + "###" + e.getId()));
        if (CollectionUtils.isEmpty(collect1)) {
            return;
        }
        JSONArray actionsArray = modules.getJSONArray("actions");
        if (!ObjectUtils.isEmpty((Object)actionsArray)) {
            for (int i = 0; i < actionsArray.size(); ++i) {
                JSONObject jsonObject = actionsArray.getJSONObject(i);
                String key = jsonObject.getString("moduleId") + "###" + jsonObject.getString("id");
                List<ActionVO> actionVOList = collect1.get(key);
                if (CollectionUtils.isEmpty(actionVOList)) continue;
                Set collect = actionVOList.get(0).getCondition().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getKey())).map(ConditionVO::getKey).collect(Collectors.toSet());
                JSONArray conditionArray = jsonObject.getJSONArray("condition");
                Iterator iterator = conditionArray.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    JSONObject jsonObject1 = JSON.parseObject((String)JSON.toJSONString(next));
                    if (jsonObject1 == null || !collect.contains(jsonObject1.getString("key"))) continue;
                    iterator.remove();
                }
            }
        }
    }

    private Object getUpdateCloudGoodModulesRequestObj(JSONObject goodObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", goodObj.getString("code"));
        ArrayList<Object> multiLanguageResourceList = new ArrayList<Object>();
        multiLanguageResourceList.add(this.generateMultiLanguageRequest(goodObj));
        multiLanguageResourceList.add(this.generateMultiLanguageRequestTW(goodObj));
        result.put("multiLanguageResource", multiLanguageResourceList);
        result.put("modules", goodObj.getJSONObject("modules"));
        return result;
    }

    private Object generateMultiLanguageRequest(JSONObject goodObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataSid", goodObj.getString("id"));
        result.put("language", "zh-CN");
        ArrayList dataList = new ArrayList();
        HashMap<String, String> goodsNameMap = new HashMap<String, String>();
        goodsNameMap.put("fieldName", "goodsName");
        HashMap<String, String> modulesMap = new HashMap<String, String>();
        modulesMap.put("fieldName", "modules");
        HashMap<String, String> customunitMap = new HashMap<String, String>();
        customunitMap.put("fieldName", "customunit");
        dataList.add(goodsNameMap);
        dataList.add(modulesMap);
        dataList.add(customunitMap);
        result.put("data", dataList);
        return result;
    }

    private Object generateMultiLanguageRequestTW(JSONObject goodObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataSid", goodObj.getString("id"));
        result.put("language", "zh-TW");
        ArrayList dataList = new ArrayList();
        HashMap<String, String> goodsNameMap = new HashMap<String, String>();
        goodsNameMap.put("fieldName", "goodsName");
        HashMap<String, String> modulesMap = new HashMap<String, String>();
        modulesMap.put("fieldName", "modules");
        HashMap<String, String> customunitMap = new HashMap<String, String>();
        customunitMap.put("fieldName", "customunit");
        dataList.add(goodsNameMap);
        dataList.add(modulesMap);
        dataList.add(customunitMap);
        result.put("data", dataList);
        return result;
    }
}

