/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.povo.BatchRequest;
import com.digiwin.athena.datamap.povo.CommonReq;
import com.digiwin.athena.datamap.povo.CommonResp;
import com.digiwin.athena.datamap.povo.MongoCrudReq;
import com.digiwin.athena.datamap.service.IBatchService;
import com.digiwin.athena.datamap.service.impl.DataMapViewService;
import com.digiwin.athena.datamap.supports.EocInfoLocal;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.times.ExpectedDuration;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.SortField;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.support.DapContext;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import io.seata.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Lang
@MyExceptionHandler
@Service
public class DatamapBatchService
implements IBatchService {
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    private MongoTemplate mongoTemplate;
    private final ThreadPoolExecutor batchPool = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, 200, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public List<Project> postProjectBasic(BatchRequest q) throws DWBusinessException {
        if (null != q.getCodes() && !q.getCodes().isEmpty()) {
            BasicQuery basicQuery = new BasicQuery();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put("code", q.getCodes());
            basicQuery.setQuery(map);
            basicQuery.setEocInfo(q.getEocInfo());
            List projects = this.dataPickService.find(basicQuery, Project.class);
            projects.forEach(p -> p.setTaskId(p.getCode()));
            return projects;
        }
        return null;
    }

    @Override
    public List<Task> postTaskBasic(BatchRequest q) throws DWBusinessException {
        if (null != q.getCodes() && !q.getCodes().isEmpty()) {
            BasicQuery basicQuery = new BasicQuery();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put("code", q.getCodes());
            basicQuery.setQuery(map);
            basicQuery.setEocInfo(q.getEocInfo());
            List tasks = this.dataPickService.find(basicQuery, Task.class);
            for (Task task : tasks) {
                task.setActivityId(task.getCode());
            }
            return tasks;
        }
        return null;
    }

    @Override
    public CommonResp postProjects(CommonReq q) throws DWBusinessException {
        List projects = this.dataPickService.find(this.convertQuery(q), Project.class);
        CommonResp resp = new CommonResp();
        resp.setDatas(projects);
        return resp;
    }

    private BasicQuery convertQuery(CommonReq q) {
        BasicQuery basicQuery = new BasicQuery();
        basicQuery.setPage(q.getPageIndex());
        basicQuery.setPageSize(q.getPageSize());
        basicQuery.setQuery(q.getQuery());
        if (null != q.getSortField()) {
            String order = q.getSortOrder();
            if (null == order) {
                order = "asc";
            }
            basicQuery.setSortFields(new ArrayList());
            basicQuery.getSortFields().add(SortField.of((String)q.getSortField(), (String)order));
        }
        return basicQuery;
    }

    @Override
    public CommonResp postTasks(CommonReq q) throws DWBusinessException {
        List projects = this.dataPickService.find(this.convertQuery(q), Task.class);
        CommonResp resp = new CommonResp();
        resp.setDatas(projects);
        return resp;
    }

    @Override
    public CommonResp postQueryCodeAndName(List<String> codes, String type, String version) {
        CommonResp resp = new CommonResp();
        Query query = new Query();
        query.fields().include("name").include("code").include("lang.name");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").in(codes).and("version").is((Object)version));
        List maps = this.mongoTemplate.find(query, Map.class, type);
        resp.setDatas(maps);
        return resp;
    }

    @Override
    public CommonResp postMongo(MongoCrudReq q) {
        CommonResp obj = new CommonResp();
        Query query1 = new Query();
        q.getQuery().forEach((k, v) -> {
            if (v instanceof Collection) {
                Collection collection = (Collection)v;
                ArrayList list = new ArrayList(collection);
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).in(list));
            } else {
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).is(v));
            }
        });
        switch (q.getOp()) {
            case "select": {
                List list = this.mongoTemplate.find(query1, Map.class, q.getCol());
                for (Map doc : list) {
                    try {
                        ObjectId objectId = (ObjectId)doc.get("_id");
                        doc.put("_id", objectId.toHexString());
                    }
                    catch (Exception objectId) {}
                }
                obj.setData(list);
                break;
            }
            case "insert": {
                this.mongoTemplate.insert((Collection)q.getDocs(), q.getCol());
                break;
            }
            case "save": {
                Map doc = (Map)q.getDoc();
                String _id = (String)doc.get("_id");
                if (null != _id) {
                    ObjectId objectId = new ObjectId(_id);
                    doc.put("_id", objectId);
                }
                this.mongoTemplate.save(q.getDoc(), q.getCol());
                break;
            }
            case "delete": {
                break;
            }
        }
        return obj;
    }

    @Override
    public Map<String, Map<String, Object>> postTaskDetails(BatchRequest q) throws DWBusinessException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (CollectionUtils.isEmpty(q.getCodes())) {
            return result;
        }
        EocInfoLocal.setEocInfo(q.getEocInfo());
        int batchSize = 10;
        if ((double)q.getCodes().size() < (double)batchSize * 1.5) {
            return this.doPostTaskDetails(q);
        }
        List codesArr = ListUtil.split(q.getCodes(), (int)batchSize);
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        DWServiceContext context = DWServiceContext.getContext();
        DapContext dapContext = ServiceUtils.getContext();
        CompletableFuture.allOf((CompletableFuture[])codesArr.stream().map(codes -> CompletableFuture.runAsync(() -> {
            DWServiceContext.setContext((DWServiceContext)context);
            ServiceUtils.setContext((DapContext)dapContext);
            try {
                EocInfoLocal.setEocInfo(q.getEocInfo());
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                BatchRequest q2 = new BatchRequest();
                q2.setCodes((List<String>)codes);
                q2.setEocInfo(q.getEocInfo());
                Map<String, Map<String, Object>> data = this.doPostTaskDetails(q2);
                result.putAll(data);
            }
            catch (DWBusinessException e) {
                throw new RuntimeException(e);
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
            }
        }, this.batchPool)).toArray(CompletableFuture[]::new)).join();
        return result;
    }

    public Map<String, Map<String, Object>> doPostTaskDetails(BatchRequest q) throws DWBusinessException {
        HashMap<String, Map<String, Object>> taskMap = new HashMap<String, Map<String, Object>>();
        if (null != q.getCodes() && !q.getCodes().isEmpty()) {
            BasicQuery basicQuery2;
            HashMap map2;
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put("code", q.getCodes());
            BasicQuery basicQuery1 = BasicQuery.of(map, q.getEocInfo());
            List tasks = this.dataPickService.find(basicQuery1, Task.class);
            HashMap<String, String> pageCodes = new HashMap<String, String>();
            HashMap<String, String> flowCodes = new HashMap<String, String>();
            for (Task task : tasks) {
                task.setActivityId(task.getCode());
                taskMap.put(task.getCode(), DataMapViewService.taskToMap(task));
                if (null != task.getPageCode()) {
                    pageCodes.put(task.getPageCode(), task.getCode());
                }
                if (null == task.getFlowCode()) continue;
                flowCodes.put(task.getFlowCode(), task.getCode());
            }
            HashMap taskActivity = new HashMap();
            if (!flowCodes.isEmpty()) {
                HashMap taskActivityCodes = new HashMap();
                map2 = new HashMap();
                map2.put("code", flowCodes.keySet());
                basicQuery2 = BasicQuery.of(map2, q.getEocInfo());
                List flows = this.dataPickService.find(basicQuery2, FlowGraph.class);
                ArrayList allCodes = new ArrayList();
                for (FlowGraph flow : flows) {
                    String taskCode = (String)flowCodes.get(flow.getCode());
                    ArrayList<String> codes = new ArrayList<String>();
                    for (FlowNode flowNode : flow.getNodes()) {
                        if (!"activity".equalsIgnoreCase(flowNode.getType())) continue;
                        codes.add(flowNode.getActivityCode());
                        allCodes.add(flowNode.getActivityCode());
                    }
                    taskActivityCodes.put(taskCode, codes);
                }
                if (!allCodes.isEmpty()) {
                    HashMap<String, Object> q2 = new HashMap<String, Object>();
                    q2.put("code", allCodes);
                    q2.put("milestone", true);
                    List activities = this.dataPickService.find(BasicQuery.of(q2, q.getEocInfo()), Activity.class);
                    block3: for (Activity activity : activities) {
                        for (Map.Entry entry : taskActivityCodes.entrySet()) {
                            if (!((List)entry.getValue()).contains(activity.getCode())) continue;
                            taskActivity.put(entry.getKey(), activity);
                            continue block3;
                        }
                    }
                }
            }
            HashMap<String, PageView> taskPageView = new HashMap<String, PageView>();
            if (!pageCodes.isEmpty()) {
                map2 = new HashMap();
                map2.put("code", pageCodes.keySet());
                basicQuery2 = BasicQuery.of(map2, q.getEocInfo());
                List pageViews = this.dataPickService.find(basicQuery2, PageView.class);
                for (PageView pageView : pageViews) {
                    String taskCode = (String)pageCodes.get(pageView.getCode());
                    taskPageView.put(taskCode, pageView);
                }
            }
            for (Task task : tasks) {
                Activity activity;
                Map viewMap = (Map)taskMap.get(task.getCode());
                PageView page = (PageView)taskPageView.get(task.getCode());
                if (null != page) {
                    if (null != page.getLang() && null != task.getLang()) {
                        page.getLang().putAll(task.getLang());
                    }
                    MergeUtil.mergeObjectToMap((Map)viewMap, (Object)page, (List)ListUtil.of((Object[])new String[]{"id", "name", "code"}));
                    if (null != q.getPageCode() && null != page.getPages()) {
                        viewMap.put("pages", page.getPages().get(q.getPageCode()));
                    }
                }
                if (null != (activity = (Activity)taskActivity.get(task.getCode()))) {
                    if (null != activity.getConfig()) {
                        viewMap.put("approve", activity.getConfig().get("approve"));
                        viewMap.put("dynamicApproves", activity.getConfig().get("dynamicApproves"));
                        viewMap.put("approveLevel", activity.getConfig().get("approveLevel"));
                    }
                    if (null != activity.getExecutor()) {
                        viewMap.put("personOnDuty", activity.getExecutor());
                    }
                    if (null != activity.getPresetVariables()) {
                        viewMap.put("presetVariables", activity.getPresetVariables());
                    }
                    viewMap.put("executorMeta", activity.getExecutorMeta());
                }
                if (null == task.getDueDate() || null != task.getExpectedDuration() || !(task.getDueDate().getValue() instanceof Number)) continue;
                Number seconds = (Number)task.getDueDate().getValue();
                ExpectedDuration expectedDuration = new ExpectedDuration();
                int value = seconds.intValue() / 86400;
                int mod = seconds.intValue() % 86400;
                if (value > 0 && mod == 0) {
                    expectedDuration.setType("DAY");
                } else {
                    value = seconds.intValue() / 3600;
                    mod = seconds.intValue() % 3600;
                    if (value > 0 && mod == 0) {
                        expectedDuration.setType("HOUR");
                    } else {
                        value = seconds.intValue() / 60;
                        expectedDuration.setType("MINUTE");
                    }
                }
                expectedDuration.setValue(value);
                task.setExpectedDuration(expectedDuration);
                viewMap.put("expectedDuration", expectedDuration);
            }
        }
        return taskMap;
    }

    public static void main(String[] args) {
        List<String> list = Arrays.asList("task_ba44810f4a4cb5d968e72d4386a9dab8", "task_bcce6bc17969c8e99bc1bda92fcff9c2", "task_d0f5fb44a5fd632418a5f673a14a8c39");
        System.out.println(ListUtil.split(list, (int)10));
    }
}

