/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.povo.GenericRequest;
import com.digiwin.athena.datamap.service.IGenericService;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.spi.AtmcService;
import com.digiwin.athena.datamap.spi.DatamapEocService;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.AppEntity2;
import com.digiwin.athena.dto.AppRelation2;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.dto.AppRelationBatchPo;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.cache.old.RedisConf;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.seata.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.CrossOrigin;

@Lang
@MyExceptionHandler
@CrossOrigin
@Service
public class GenericService
implements IGenericService {
    private static final Logger log = LoggerFactory.getLogger(GenericService.class);
    @Autowired
    RedisConf redisConf;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    ActionRepository actionRepository;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    DatamapAppService kgService;
    @Autowired
    AtmcService atmcService;
    @Autowired
    DatamapEocService datamapEocService;

    @Override
    public Object postProjectMeta(GenericRequest request) throws DWException {
        DataDescription dataDescription;
        DataState state;
        String stateCode;
        String code = request.getCode();
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        Project project = (Project)this.dataPickService.findByCode(code, Project.class);
        if (null != project && null != project.getInit() && null != (stateCode = project.getInit().getCode()) && null != (state = (DataState)this.dataPickService.findByCode(stateCode, DataState.class)) && null != state.getDataCode() && null != (dataDescription = (DataDescription)this.dataPickService.findByCode(state.getDataCode(), DataDescription.class)) && null != dataDescription.getDataStruct()) {
            FieldDescription mainData = dataDescription.getDataStruct();
            mainData.setKey("data");
            mainData.setName(dataDescription.getName());
            mainData.setDataType("ARRAY");
            mainData.setComponentType("object");
            ApiDataFieldMetadataDTO dto = GenericService.fd2ApiDataFieldMetadataDTO(dataDescription.getDataStruct());
            fields.add(dto);
        }
        return fields;
    }

    @Override
    public Object postTaskMeta(GenericRequest request) throws DWException {
        String code = request.getCode();
        return this.taskStruct(code);
    }

    @Override
    public Object postTaskPageMeta(GenericRequest request) throws DWException {
        String code = request.getCode();
        Task task = (Task)this.dataPickService.findByCode(code, Task.class);
        if (null == task) {
            return null;
        }
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        if (null != task.getPageCode()) {
            PageView pageView = (PageView)this.dataPickService.findByCode(task.getPageCode(), PageView.class);
            fields.addAll(this.pageFields(pageView));
        }
        return fields;
    }

    @Override
    public Object postDecisionObjectList(GenericRequest request) throws DWException {
        String code = request.getCode();
        Task task = (Task)this.dataPickService.findByCode(code, Task.class);
        if (null == task) {
            return null;
        }
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        ArrayList openWindowFeildList = new ArrayList();
        if (null != task.getPageCode()) {
            PageView pageView = (PageView)this.dataPickService.findByCode(task.getPageCode(), PageView.class);
            fields.addAll(this.pageFields(pageView));
            JSONObject map = JSON.parseObject((String)JSON.toJSONString((Object)pageView));
            Object obj = JsonPath.read((Object)map, (String)"$.pages.task-detail.dataStates[*].operations[*]", (Predicate[])new Predicate[0]);
            JSONArray openWindowArray = JSON.parseArray((String)obj.toString());
            List applyToFields = openWindowArray.stream().map(v -> {
                JSONObject jsonObject = (JSONObject)v;
                return jsonObject.getString("applyToField");
            }).collect(Collectors.toList());
            openWindowFeildList.addAll(applyToFields);
        }
        if (ObjectUtils.isEmpty(fields)) {
            return null;
        }
        fields.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getField())).forEach(v -> v.getField().forEach(t -> {
            if (!ObjectUtils.isEmpty((Object)t.getEnum_key())) {
                t.setMetaFieldType(MechanismEnum.ComponentType.SELECTOR.getCode());
            } else if (!ObjectUtils.isEmpty((Object)openWindowFeildList) && openWindowFeildList.contains(t.getData_name())) {
                t.setMetaFieldType(MechanismEnum.ComponentType.OPEN_WINDOW.getCode());
            }
        }));
        return fields;
    }

    @Override
    public Object postProjectPageMeta(GenericRequest request) throws DWException {
        String code = request.getCode();
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("project", code);
        query.put("pageType", 1);
        PageView pageView = (PageView)this.dataPickService.findOne(BasicQuery.of(query, null), PageView.class);
        fields.addAll(this.pageFields(pageView));
        return fields;
    }

    @Override
    public Object postCleanCache(GenericRequest request) throws DWException {
        StringBuilder kmPattern = new StringBuilder();
        if (null != request.getModule()) {
            kmPattern.append(request.getModule());
        } else {
            kmPattern.append("km");
        }
        kmPattern.append(":SYSTEM:");
        if (null != request.getTenantId()) {
            kmPattern.append(request.getTenantId()).append(":*");
        } else {
            kmPattern.append("*");
        }
        String pattern = kmPattern.toString();
        int count = 2000;
        Long result = this.blurScanDelete(pattern, count);
        System.out.println(pattern);
        this.atmcService.cleanCache();
        return result;
    }

    @Override
    public void delMatch(String pattern) {
        if (!this.redisConf.getUse().booleanValue()) {
            return;
        }
        int count = 2000;
        Long delete = this.blurScanDelete(pattern, count);
        log.info("delMatch delete size,{}", (Object)delete);
    }

    public Long blurScanDelete(String matchKey, int count) {
        return (Long)this.redisTemplate.execute(connection -> {
            long keyCount = 0L;
            try (Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().count((long)count).match(matchKey).build());){
                long cursorId = cursor.getCursorId();
                HashSet<String> keys = new HashSet<String>();
                while (cursor.hasNext()) {
                    keys.add(new String((byte[])cursor.next()));
                    if (cursorId != cursor.getCursorId()) {
                        keyCount += (long)keys.size();
                        this.redisTemplate.delete(keys);
                        keys = new HashSet();
                    }
                    cursorId = cursor.getCursorId();
                }
                if (cursor.getCursorId() == 0L || CollectionUtils.isNotEmpty(keys)) {
                    keyCount += (long)keys.size();
                    this.redisTemplate.delete(keys);
                }
            }
            catch (Exception e) {
                log.error("blurScanDelete failed,{}", (Object)e.toString());
            }
            return keyCount;
        });
    }

    @Override
    public Object postAppRelations(GenericRequest request) throws Exception {
        int batchSize = 1000;
        HashMap resp = new HashMap();
        String type = request.getType();
        ArrayList<String> msg = new ArrayList<String>();
        HashSet<String> codes = new HashSet<String>();
        ArrayList<AppRelation2> list = new ArrayList<AppRelation2>();
        List<AppEntity2> relation2s = this.appEntitys();
        HashMap namespaceToCode = new HashMap();
        relation2s.forEach(appEntity2 -> {
            if (null != appEntity2.getNamespace()) {
                namespaceToCode.put(appEntity2.getNamespace(), appEntity2);
            }
        });
        List objects = null;
        String rType = null;
        if ("project".equalsIgnoreCase(type)) {
            objects = this.mongoTemplate.findAll(Project.class);
            rType = "task";
        } else if ("task".equalsIgnoreCase(type)) {
            objects = this.mongoTemplate.findAll(Task.class);
            rType = "activity";
        } else {
            return resp;
        }
        for (TenantObject p : objects) {
            if (null == p.getAthena_namespace()) {
                msg.add("code:" + p.getCode() + " application is null");
                continue;
            }
            if (codes.contains(p.getCode())) continue;
            codes.add(p.getCode());
            AppEntity2 appEntity22 = (AppEntity2)namespaceToCode.get(p.getAthena_namespace());
            if (null == appEntity22) {
                if (Boolean.TRUE.equals(request.getApplicationAsAppCodeWhenNull())) {
                    appEntity22 = new AppEntity2();
                    appEntity22.setName("appEntityNull");
                    appEntity22.setCode(p.getAthena_namespace());
                } else {
                    msg.add("code:" + p.getCode() + " can not get AppEntity by application:" + p.getAthena_namespace());
                    continue;
                }
            }
            AppRelation2 relation2 = new AppRelation2();
            relation2.setType(rType);
            relation2.setCode(p.getCode());
            relation2.setApplication(p.getAthena_namespace());
            relation2.setAppCode(appEntity22.getCode());
            relation2.setAppName(appEntity22.getName());
            relation2.setSource("datamap");
            relation2.setVersion(p.getVersion());
            list.add(relation2);
        }
        if (Boolean.TRUE.equals(request.getBatch())) {
            AppRelationBatchPo po = new AppRelationBatchPo();
            List list2 = JSON.parseArray((String)JSON.toJSONString(list), ApplicationRelation.class);
            po.setList(list2);
            this.kgService.postAppRelationUpdate(po);
        } else {
            resp.put("list", list);
        }
        resp.put("msg", msg);
        return resp;
    }

    @Override
    public Object getCorp() throws DWException {
        return this.datamapEocService.eocInfo();
    }

    public List<ApiDataFieldMetadataDTO> taskStruct(String taskCode) throws DWBusinessException {
        DataDescription dataDescription;
        DataState state;
        String stateCode;
        Task task = (Task)this.dataPickService.findByCode(taskCode, Task.class);
        if (null == task) {
            return null;
        }
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        if (null != task && task.getStateMaps().size() > 0 && null != (stateCode = ((StateMap)task.getStateMaps().get(0)).getInput()) && null != (state = (DataState)this.dataPickService.findByCode(stateCode, DataState.class)) && null != state.getDataCode() && null != (dataDescription = (DataDescription)this.dataPickService.findByCode(state.getDataCode(), DataDescription.class)) && null != dataDescription.getDataStruct()) {
            FieldDescription mainData = dataDescription.getDataStruct();
            mainData.setKey("data");
            mainData.setName(dataDescription.getName());
            mainData.setDataType("ARRAY");
            mainData.setComponentType("object");
            ApiDataFieldMetadataDTO dto = GenericService.fd2ApiDataFieldMetadataDTO(dataDescription.getDataStruct());
            fields.add(dto);
        }
        return fields;
    }

    public List<ApiDataFieldMetadataDTO> pageStruct(String taskCode) throws DWBusinessException {
        Task task = (Task)this.dataPickService.findByCode(taskCode, Task.class);
        if (null == task) {
            return null;
        }
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        if (null != task.getPageCode()) {
            PageView pageView = (PageView)this.dataPickService.findByCode(task.getPageCode(), PageView.class);
            fields.addAll(this.pageFields(pageView));
        }
        return fields;
    }

    private List<ApiDataFieldMetadataDTO> pageFields(PageView pageView) {
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        ApiDataFieldMetadataDTO dto0 = this.pageField(pageView);
        if (null != dto0) {
            fields.add(dto0);
            return fields;
        }
        if (null != pageView && null != pageView.getDataSources()) {
            pageView.getDataSources().forEach((k, v) -> {
                try {
                    Map map = (Map)v;
                    String actionId = (String)map.get("actionId");
                    ApiDataFieldMetadataDTO dto = this.actionResponseDto(actionId);
                    if (null != dto) {
                        dto.setData_name(k);
                        fields.add(dto);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        return fields;
    }

    public ApiDataFieldMetadataDTO pageField(PageView pageView) {
        if (null == pageView || null == pageView.getDataSources()) {
            return null;
        }
        Object dataSourceName = JSONPath.eval((Object)pageView, (String)"$.pages['task-detail'].dataStates[0].dataFilter.dataSourceNames[0]");
        if (null == dataSourceName) {
            dataSourceName = JSONPath.eval((Object)pageView, (String)"$.dataFilters[applyTo like '%task-detail%'].dataSourceNames[0][0]");
        }
        if (null == dataSourceName) {
            return null;
        }
        Map datasource = (Map)pageView.getDataSources().get(dataSourceName);
        if (null == datasource) {
            return null;
        }
        String actionId = (String)datasource.get("actionId");
        ApiDataFieldMetadataDTO dto = this.actionResponseDto(actionId);
        if (null != dto) {
            dto.setData_name((String)dataSourceName);
            return dto;
        }
        return dto;
    }

    public ApiDataFieldMetadataDTO actionResponseDto(String actionId) {
        try {
            String version = this.dataPickService.tenantVersion();
            log.info("GenericService.actionResponseDto\uff0c\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\uff0cactionIc={}, version={}", (Object)actionId, (Object)version);
            List actions = this.actionRepository.getActionByActionId(actionId, version);
            if (actions.size() == 0) {
                return null;
            }
            Action action = (Action)actions.get(0);
            if (StringUtils.isEmpty((CharSequence)action.getResponse_object())) {
                return null;
            }
            ApiDataFieldMetadataDTO dto = (ApiDataFieldMetadataDTO)JSON.parseObject((String)action.getResponse_object(), ApiDataFieldMetadataDTO.class);
            dto.setName(action.getActionName());
            this.apiFieldNameLocaleProcess(dto);
            return dto;
        }
        catch (DWBusinessException e) {
            log.error("GenericService.actionResponseDto \u6839\u636eactionId\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff0ce={}", (Throwable)e);
            return null;
        }
    }

    public Map<String, ApiDataFieldMetadataDTO> actionResponseDtos(Set<String> actionIds) {
        HashMap<String, ApiDataFieldMetadataDTO> resp = new HashMap<String, ApiDataFieldMetadataDTO>();
        List actions = this.actionRepository.getActionByActionIds(actionIds);
        for (Action action : actions) {
            if (StringUtils.isEmpty((CharSequence)action.getResponse_object())) continue;
            ApiDataFieldMetadataDTO dto = (ApiDataFieldMetadataDTO)JSON.parseObject((String)action.getResponse_object(), ApiDataFieldMetadataDTO.class);
            dto.setName(action.getActionName());
            this.apiFieldNameLocaleProcess(dto);
            resp.put(action.getActionId(), dto);
        }
        return resp;
    }

    private void apiFieldNameLocaleProcess(ApiDataFieldMetadataDTO dto) {
        String locale = ServiceUtils.getCurrentLocale();
        if (null == locale) {
            locale = "zh_CN";
        }
        if (null == dto.getName() && null != dto.getDescription()) {
            dto.setName(dto.getDescription().getZh_CN());
            if ("zh_TW".equalsIgnoreCase(locale)) {
                dto.setName(dto.getDescription().getZh_TW());
            } else if ("en_US".equalsIgnoreCase(locale)) {
                dto.setName(dto.getDescription().getEn_US());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getField())) {
            for (ApiDataFieldMetadataDTO d : dto.getField()) {
                this.apiFieldNameLocaleProcess(d);
            }
        }
        dto.setDescriptionLang(dto.getDescription());
    }

    public List<ApiDataFieldMetadataDTO> dataStruct(String dataCode) throws DWBusinessException {
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        DataDescription dataDescription = (DataDescription)this.dataPickService.findByCode(dataCode, DataDescription.class);
        if (null != dataDescription && null != dataDescription.getDataStruct()) {
            FieldDescription mainData = dataDescription.getDataStruct();
            mainData.setKey("data");
            mainData.setName(dataDescription.getName());
            mainData.setDataType("ARRAY");
            mainData.setComponentType("object");
            ApiDataFieldMetadataDTO dto = GenericService.fd2ApiDataFieldMetadataDTO(dataDescription.getDataStruct());
            fields.add(dto);
        }
        return fields;
    }

    public List<ApiDataFieldMetadataDTO> projectPageStruct(String projectCode) throws DWBusinessException {
        ArrayList<ApiDataFieldMetadataDTO> fields = new ArrayList<ApiDataFieldMetadataDTO>();
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("project", projectCode);
        query.put("pageType", 1);
        PageView pageView = (PageView)this.dataPickService.findOne(BasicQuery.of(query, null), PageView.class);
        fields.addAll(this.pageFields(pageView));
        return fields;
    }

    public static ApiDataFieldMetadataDTO fd2ApiDataFieldMetadataDTO(FieldDescription fd) {
        if (null == fd) {
            return null;
        }
        ApiDataFieldMetadataDTO dto = new ApiDataFieldMetadataDTO();
        dto.setData_name(fd.getKey());
        dto.setName(fd.getName());
        if ("ARRAY".equalsIgnoreCase(fd.getDataType())) {
            dto.setData_type(fd.getComponentType());
            dto.setIs_array(Boolean.valueOf(true));
        } else {
            dto.setData_type(fd.getDataType());
            dto.setIs_array(Boolean.valueOf(false));
        }
        if (null != fd.getRequired()) {
            dto.setRequired(fd.getRequired().toString());
        }
        if (null != fd.getFields()) {
            dto.setField(new ArrayList());
            for (FieldDescription fd2 : fd.getFields()) {
                ApiDataFieldMetadataDTO dto2 = GenericService.fd2ApiDataFieldMetadataDTO(fd2);
                dto.getField().add(dto2);
            }
        }
        return dto;
    }

    public List<AppEntity2> appEntitys() {
        Session session = this.sessionFactory.openSession();
        HashMap param = new HashMap();
        Result result = session.query("match(a:AppEntity) return a.code as code,a.name as name,a.namespace as namespace", param);
        ArrayList<AppEntity2> list = new ArrayList<AppEntity2>();
        for (Map map : result) {
            if (null == map || map.size() <= 0) continue;
            AppEntity2 entity2 = new AppEntity2();
            entity2.setCode((String)map.get("code"));
            entity2.setName((String)map.get("name"));
            entity2.setNamespace((String)map.get("namespace"));
            list.add(entity2);
        }
        return list;
    }
}

