/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.configuration.DataMapModuleConfiguration;
import com.digiwin.athena.datamap.povo.meta.MetaRequest;
import com.digiwin.athena.datamap.povo.meta.MetaResponse;
import com.digiwin.athena.datamap.service.IMetaService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.common.TenantObject;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MetaService
implements IMetaService {
    @Autowired
    DataMapPickService dataPickService;

    @Override
    public <T extends TenantObject> MetaResponse postQuery(MetaRequest req) throws DWException {
        Class<T> c = this.validateCode(req);
        List list = this.dataPickService.find(req, c);
        return MetaResponse.success(list);
    }

    @Override
    public <T extends TenantObject> MetaResponse postRemove(MetaRequest req) throws DWException {
        Class<T> c = this.validateCode(req);
        long count = this.dataPickService.remove(req, c);
        return MetaResponse.success(count);
    }

    @Override
    public <T extends TenantObject> MetaResponse postUpdate(MetaRequest req) throws DWException {
        Class<T> c = this.validateCode(req);
        long count = this.dataPickService.update(req, c);
        return MetaResponse.success(count);
    }

    @Override
    public <T extends TenantObject> MetaResponse postSave(MetaRequest req) throws DWException {
        Class<T> c = this.validateCode(req);
        Map data = req.getData();
        if (null == data) {
            return null;
        }
        TenantObject t = (TenantObject)JSON.parseObject((String)JSON.toJSONString((Object)data), c);
        this.dataPickService.save(t, c);
        return null;
    }

    private <T extends TenantObject> Class<T> validateCode(MetaRequest request) {
        Assert.notNull((Object)request.getCode(), (String)"code is null");
        Class clz = DataMapModuleConfiguration.codeToClass.get(request.getCode());
        Assert.notNull((Object)clz, (String)("code not registered code=" + request.getCode()));
        return clz;
    }
}

