/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.athena.datamap.service.IPresetCollectionService;
import com.digiwin.athena.datamap.spi.DbPresetService;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class PresetCollectionService
implements IPresetCollectionService {
    @Autowired
    private DbPresetService dbPresetService;

    @Override
    public void put(String name) throws Exception {
        this.dbPresetService.getCollection(name, new String[0]);
    }

    @Override
    public void delete(String name) throws Exception {
        MongoCollection<Document> col = this.dbPresetService.getCollection(name, new String[0]);
        col.drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getList(String name, Map<String, Object> conditions, int limit) throws Exception {
        MongoCursor cursor;
        ArrayList<Object> re = new ArrayList<Object>();
        BasicDBObject sortObj = new BasicDBObject();
        sortObj.put((Object)"createDate", (Object)-1);
        MongoCollection<Document> col = this.dbPresetService.getCollection(name, new String[0]);
        if (CollectionUtils.isEmpty(conditions)) {
            cursor = limit > 0 ? col.find().projection(Projections.excludeId()).sort((Bson)sortObj).limit(limit).iterator() : col.find().projection(Projections.excludeId()).sort((Bson)sortObj).iterator();
        } else {
            ArrayList<Bson> con = new ArrayList<Bson>();
            for (Map.Entry<String, Object> entry : conditions.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    con.add(Filters.in((String)entry.getKey(), (Object[])new Object[]{entry.getValue()}));
                    continue;
                }
                con.add(Filters.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
            cursor = limit > 0 ? col.find(Filters.and((Bson[])con.toArray(new Bson[0]))).projection(Projections.excludeId()).sort((Bson)sortObj).limit(limit).iterator() : col.find(Filters.and((Bson[])con.toArray(new Bson[0]))).projection(Projections.excludeId()).sort((Bson)sortObj).iterator();
        }
        try {
            while (cursor.hasNext()) {
                re.add(cursor.next());
            }
        }
        finally {
            cursor.close();
        }
        return re.toArray(new Map[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getList(String name, Map<String, Object> conditions, int limit, String ... indexes) throws Exception {
        MongoCursor cursor;
        ArrayList<Object> re = new ArrayList<Object>();
        BasicDBObject sortObj = new BasicDBObject();
        sortObj.put((Object)"createDate", (Object)-1);
        MongoCollection<Document> col = this.dbPresetService.getCollection(name, indexes);
        if (CollectionUtils.isEmpty(conditions)) {
            cursor = limit > 0 ? col.find().projection(Projections.excludeId()).sort((Bson)sortObj).limit(limit).iterator() : col.find().projection(Projections.excludeId()).sort((Bson)sortObj).iterator();
        } else {
            ArrayList<Bson> con = new ArrayList<Bson>();
            for (Map.Entry<String, Object> entry : conditions.entrySet()) {
                if (entry.getValue() instanceof Collection) {
                    con.add(Filters.in((String)entry.getKey(), (Iterable)((Collection)entry.getValue())));
                    continue;
                }
                con.add(Filters.eq((String)entry.getKey(), (Object)entry.getValue()));
            }
            cursor = limit > 0 ? col.find(Filters.and((Bson[])con.toArray(new Bson[0]))).projection(Projections.excludeId()).sort((Bson)sortObj).limit(limit).iterator() : col.find(Filters.and((Bson[])con.toArray(new Bson[0]))).projection(Projections.excludeId()).sort((Bson)sortObj).iterator();
        }
        try {
            while (cursor.hasNext()) {
                re.add(cursor.next());
            }
        }
        finally {
            cursor.close();
        }
        return re.toArray(new Map[0]);
    }
}

