/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.povo.DataRequest;
import com.digiwin.athena.datamap.service.IProjectService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.core.MonitorRuleAdapter;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.dtdflow.CustBizTask;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.customBizTask.CustBizTaskConfigDTO;
import com.digiwin.athena.domain.customBizTask.CustGroupSkipCondition;
import com.digiwin.athena.domain.customBizTask.CustomSkipExpression;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@MyExceptionHandler
@Service
public class ProjectService
implements IProjectService {
    private static final Logger log = LoggerFactory.getLogger(ProjectService.class);
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    DataMapPickService dataPickService;

    public Project getUserProject(String projectCode, String stateCode) throws DWException {
        Project up = null;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("primaryProjectCode", projectCode);
        param.put("init.code", stateCode);
        param.put("executeType", "user");
        up = (Project)this.dataPickService.findOne(BasicQuery.of(param, null), Project.class);
        return up;
    }

    public Task manualProjectPageTask(String projectCode) throws DWBusinessException {
        HashMap<String, Object> query2 = new HashMap<String, Object>();
        query2.put("project", projectCode);
        query2.put("pageType", 1);
        PageView pageView = (PageView)this.dataPickService.findBetter(BasicQuery.of(query2, null), PageView.class);
        if (null != pageView) {
            HashMap<String, String> query3 = new HashMap<String, String>();
            query3.put("pageCode", pageView.getCode());
            List tasks3 = this.dataPickService.find(BasicQuery.of(query2, null), Task.class);
            if (CollectionUtils.isNotEmpty((Collection)tasks3)) {
                Task taskMaster3 = (Task)tasks3.get(0);
                return taskMaster3;
            }
        }
        return null;
    }

    @Override
    public List<Project> postProjects(BasicQuery query) throws DWException {
        List list = this.dataPickService.find(query, Project.class);
        return list;
    }

    @Override
    public Project postProject(BasicQuery request) throws DWException {
        Project project = (Project)this.dataPickService.findBetter(request, Project.class);
        return project;
    }

    @Override
    public Project getProjectByCode(String code) throws DWException {
        Project p = (Project)this.dataPickService.findBetter(code, Project.class);
        return p;
    }

    @Override
    @Deprecated
    public Project postFixProjectByCode(String code) throws DWException {
        log.info("fix Project:{}", (Object)code);
        String version = this.dataPickService.tenantVersion();
        String tenantId = ServiceUtils.getTenantId();
        Project ts = (Project)this.dataPickService.tenantTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code).and("tenantId").is((Object)tenantId).and("version").lte((Object)version)), Project.class);
        ts.setDueDateTimeDistance(null);
        ts.setDateTimeDistance(null);
        this.dataPickService.tenantTemplate().save((Object)ts);
        return ts;
    }

    @Override
    public Project postProjectByCode(DataRequest request) throws DWException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("code", request.getCode());
        Project p = (Project)this.dataPickService.findBetter(BasicQuery.of(param, request.getEocInfo()), Project.class);
        return p;
    }

    @Override
    public Project getProjectByCode2(String code, String tenantId) throws DWException {
        ServiceUtils.getContext().getProfiles().put("tenantId", tenantId);
        Project p = (Project)this.dataPickService.findBetter(code, Project.class);
        return p;
    }

    @Override
    public MonitorRuleAdapter getMonitorConfig(String id) throws DWException {
        String tenantId = ServiceUtils.getTenantId();
        MonitorRuleAdapter ruleAdapter = (MonitorRuleAdapter)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"dataEventId").is((Object)id)), MonitorRuleAdapter.class);
        ruleAdapter.setTenantId(tenantId);
        return ruleAdapter;
    }

    @Override
    public List<Project> getProjectByAuthorityPrefix(String authorityPrefix) throws DWException {
        List projects = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"authorityPrefix").is((Object)authorityPrefix).and("tenantId").is((Object)"SYSTEM")), Project.class);
        return projects;
    }

    @Override
    public List<Project> getCustBizProjectByApp(String appCode) throws DWException {
        String version = this.dataPickService.tenantVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "2.0";
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)appCode).and("taskCanCustom").is((Object)Boolean.TRUE).and("version").is((Object)version));
        List projectList = this.dataPickService.systemTemplate().find(query, Project.class);
        return projectList;
    }

    @Override
    public List<CustGroupSkipCondition> getCustBizField(String appCode, String projectCode) throws DWException {
        String version = this.dataPickService.tenantVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "2.0";
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)projectCode).and("version").is((Object)version));
        Project project = (Project)this.dataPickService.systemTemplate().findOne(query, Project.class);
        if (null == project || null == project.getCustomSkipConfig()) {
            return null;
        }
        return project.getCustomSkipConfig().getCustomSKipConditions();
    }

    @Override
    public CustBizTaskConfigDTO saveCustBizConfig(CustBizTaskConfigDTO configDTO) throws DWException {
        if (StringUtils.isEmpty((CharSequence)configDTO.getCode())) {
            configDTO.setCode(UUID.randomUUID().toString().replace("-", ""));
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)configDTO.getCode()));
            this.dataPickService.tenantTemplate().remove(query, "customBizTaskConfig");
        }
        this.dataPickService.tenantTemplate().save((Object)configDTO, "customBizTaskConfig");
        List bizTasks = configDTO.getBizTasks();
        bizTasks.stream().forEach(v -> {
            try {
                this.setTaskCustomConfig((CustBizTask)v, configDTO);
            }
            catch (DWException e) {
                throw new RuntimeException(e);
            }
        });
        return configDTO;
    }

    private void setTaskCustomConfig(CustBizTask custBizTask, CustBizTaskConfigDTO configDTO) throws DWException {
        Task task;
        String version = this.dataPickService.tenantVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "2.0";
        }
        if (null == (task = (Task)this.dataPickService.systemTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)custBizTask.getCode()).and("version").is((Object)version)), Task.class))) {
            return;
        }
        task.setProjectCode(configDTO.getProjectCode());
        Task tanantTask = (Task)this.dataPickService.tenantTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)custBizTask.getCode()).and("tenantId").is((Object)ServiceUtils.getTenantId()).and("pluginId").is(null).and("eocInfo").is(null)), Task.class);
        if (null == tanantTask) {
            BeanUtils.copyProperties((Object)custBizTask, (Object)task, Task.class);
        } else {
            tanantTask.setCustomCanSkip(task.getCustomCanSkip());
            BeanUtils.copyProperties((Object)tanantTask, (Object)task, Task.class);
            task.setCustomSkip(custBizTask.getCustomSkip());
        }
        List groupSkipConfigs = configDTO.getGroupSkipConfig();
        if (!CollectionUtils.isEmpty((Collection)groupSkipConfigs)) {
            ArrayList groupSkipConditions = new ArrayList();
            groupSkipConfigs.stream().forEach(v -> {
                CustGroupSkipCondition groupSkipCondition = new CustGroupSkipCondition();
                Optional<Task> groupCustTask = v.getBizTasks().stream().filter(t -> t.getCode().equals(custBizTask.getCode())).findFirst();
                if (groupCustTask.isPresent()) {
                    groupSkipCondition.setCustomSkip(groupCustTask.get().getCustomSkip());
                    ArrayList customSkipExpressions = new ArrayList();
                    v.getCustomSkipConditions().stream().forEach(c -> {
                        CustomSkipExpression customSkipExpression = new CustomSkipExpression();
                        BeanUtils.copyProperties((Object)c, (Object)customSkipExpression, CustomSkipExpression.class);
                        customSkipExpression.setVar(c.getKey());
                        customSkipExpressions.add(customSkipExpression);
                    });
                    groupSkipCondition.setExpressions(customSkipExpressions);
                    groupSkipConditions.add(groupSkipCondition);
                }
            });
            if (!CollectionUtils.isEmpty(groupSkipConditions)) {
                task.setCustomSkipConditions(groupSkipConditions);
            }
        }
        if (tanantTask != null) {
            this.dataPickService.tenantTemplate().remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)tanantTask.getId()).and("tenantId").is((Object)ServiceUtils.getTenantId())), Task.class);
        }
        task.setTenantId(ServiceUtils.getTenantId());
        task.setCustomGroupSkip(configDTO.getCustomGroupSkip());
        this.dataPickService.tenantTemplate().save((Object)task, "task");
    }
}

