/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.service.IRuleService;
import com.digiwin.athena.datamap.service.impl.DataMapTenantService;
import com.digiwin.athena.datamap.service.impl.DatamapAppService;
import com.digiwin.athena.datamap.service.impl.GenericService;
import com.digiwin.athena.datamap.service.impl.PresetCollectionService;
import com.digiwin.athena.datamap.service.impl.PresetService;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.preset.AppDiff;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.PresetFeatureEnum;
import com.digiwin.athena.preset.Rule;
import com.digiwin.athena.preset.dto.PresetDTO;
import com.digiwin.athena.preset.dto.RuleDTO;
import io.seata.common.util.CollectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
@MyExceptionHandler
public class RuleService
implements IRuleService {
    private static final Logger log = LoggerFactory.getLogger(RuleService.class);
    protected static final String RULE_COLNAME = "rules";
    protected static final String TENANT_RULE_COLNAME = "tenantRules";
    @Autowired
    DatamapAppService datamapAppService;
    @Autowired
    @Qualifier(value="presetMongoTemplate")
    MongoTemplate mongoTemplate;
    @Autowired
    GenericService genericService;
    @Autowired
    PresetService presetService;
    @Autowired
    DataMapTenantService dataMapTenantService;
    @Autowired
    PresetCollectionService presetCollectionService;

    public List disabledDomainIds(String domain, String activityId) throws Exception {
        Query query;
        List appDiffs;
        ArrayList ids = new ArrayList();
        List<String> apps = this.dataMapTenantService.getAppCodes();
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type("activity").codes(Collections.singletonList(activityId)).build();
        List<ApplicationRelation> applicationRelations = this.datamapAppService.postApplicationByTypeAndCodeList(queryDTO);
        if (CollectionUtils.isEmpty(apps) || CollectionUtils.isEmpty(applicationRelations)) {
            return ids;
        }
        List apps2 = applicationRelations.stream().map(ApplicationRelation::getAppCode).collect(Collectors.toList());
        apps.retainAll(apps2);
        if (!apps.isEmpty() && !(appDiffs = this.mongoTemplate.find(query = Query.query((CriteriaDefinition)Criteria.where((String)"application").in(apps).and("domain").is((Object)domain).and("mode").is((Object)"remove")), AppDiff.class)).isEmpty()) {
            HashMap<Object, List> domainMap = new HashMap<Object, List>();
            for (AppDiff diff : appDiffs) {
                ArrayList<String> appCodes = (ArrayList<String>)domainMap.get(diff.getDomainId());
                if (null == appCodes) {
                    appCodes = new ArrayList<String>();
                    domainMap.put(diff.getDomainId(), appCodes);
                }
                appCodes.add(diff.getApplication());
            }
            ArrayList domainIds = new ArrayList();
            domainMap.forEach((k, v) -> {
                if (v.containsAll(apps)) {
                    domainIds.add(k);
                }
            });
            return domainIds;
        }
        return ids;
    }

    @Override
    @Cache(namespace="knowledgegraph:preset", key="postQuery2$0$1", language=true, tenant=true, ttlSecs=86400L)
    public Object postQuery(String activityId, int count) throws Exception {
        return this.postCommonQuery(activityId, count, new HashMap<PresetFeatureEnum, Object>());
    }

    @Override
    @Cache(namespace="knowledgegraph:preset", key="postQuery3$0$1$2", language=true, tenant=true, ttlSecs=86400L)
    public Object postQuery(String activityId, int count, Map<PresetFeatureEnum, Object> features) throws Exception {
        return this.postCommonQuery(activityId, count, features);
    }

    public Object postCommonQuery(String activityId, int count, Map<PresetFeatureEnum, Object> features) throws Exception {
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            throw new DWArgumentException("activityId", I18nUtils.getValue((String)"preset.activityIdEmpty", (Object[])new Object[0]));
        }
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataMapTenantService.getTenantVersion(tenantId);
        HashMap<String, Object> con = new HashMap<String, Object>();
        con.put("domain", PresetDomainEnum.ACTIVITY.toString());
        if (activityId.contains("-")) {
            activityId = activityId.substring(0, activityId.indexOf("-"));
        }
        con.put("domainId", activityId);
        con.put("version", tenantVersion);
        ApplicationRelation applicationRelation = this.datamapAppService.getApplicationByTypeAndCode("activity", activityId);
        if (applicationRelation != null && tenantId.equals(applicationRelation.getTenantId())) {
            con.put("tenantId", Collections.singletonList(tenantId));
        } else {
            con.put("tenantId", Arrays.asList("SYSTEM", null));
        }
        Map[] re = (Map[])this.presetCollectionService.getList(RULE_COLNAME, con, count, "key", "version");
        re = this.filterIndividual(re);
        HashMap<String, Object> tenantCondition = new HashMap<String, Object>();
        tenantCondition.put("domain", PresetDomainEnum.ACTIVITY.toString());
        tenantCondition.put("domainId", activityId);
        tenantCondition.put("version", tenantVersion);
        tenantCondition.put("tenantId", tenantId);
        Map[] tenantLevelResult = (Map[])this.presetCollectionService.getList(TENANT_RULE_COLNAME, tenantCondition, count, "key", "version");
        ArrayList rules = new ArrayList();
        ArrayList<HashMap<String, Object>> systemRules = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> tenantRules = new ArrayList<HashMap<String, Object>>();
        ArrayList<String> duplicateRemovalKey = new ArrayList<String>();
        if (tenantLevelResult.length > 0) {
            for (Map r : tenantLevelResult) {
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                tmp.put("key", r.get("key"));
                tmp.put("name", r.get("name"));
                tmp.put("pluginId", r.get("pluginId"));
                Map obj = (Map)r.get("content");
                duplicateRemovalKey.add(obj.get("key") + "-" + obj.get("schema"));
                tmp.put("content", obj);
                this.supplementResult(features, r, tmp);
                tenantRules.add(tmp);
            }
        }
        if (re.length > 0) {
            for (Map r : re) {
                Map obj = (Map)r.get("content");
                if ("required".equalsIgnoreCase(String.valueOf(obj.get("key"))) && duplicateRemovalKey.contains(obj.get("key") + "-" + obj.get("schema"))) continue;
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                tmp.put("key", r.get("key"));
                tmp.put("name", r.get("name"));
                tmp.put("pluginId", r.get("pluginId"));
                tmp.put("content", obj);
                this.supplementResult(features, r, tmp);
                systemRules.add(tmp);
            }
        }
        rules.addAll(systemRules);
        rules.addAll(tenantRules);
        rules.sort((r1, r2) -> {
            int intR2 = ObjectUtils.isEmpty(r2.get("sequence")) ? 0 : Integer.parseInt(r2.get("sequence").toString());
            int intR1 = ObjectUtils.isEmpty(r1.get("sequence")) ? 0 : Integer.parseInt(r1.get("sequence").toString());
            return intR1 - intR2;
        });
        HashMap result = new HashMap();
        result.put(RULE_COLNAME, rules);
        return result;
    }

    private Map<String, Object>[] filterIndividual(Map<String, Object>[] re) throws IOException, DWBusinessException {
        boolean suspended = false;
        for (Map<String, Object> rule : re) {
            Integer sourceLevel = (Integer)rule.get("sourceLevel");
            if (null == sourceLevel) {
                rule.put("sourceLevel", 1000);
                continue;
            }
            if (sourceLevel >= 1000) continue;
            suspended = true;
        }
        Arrays.sort(re, (o1, o2) -> {
            Integer sl1 = (Integer)o1.get("sourceLevel");
            Integer sl2 = (Integer)o2.get("sourceLevel");
            return sl1 - sl2;
        });
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, Object> rule : re) {
            String key = (String)rule.get("key");
            Integer sourceLevel = (Integer)rule.get("sourceLevel");
            if (keys.contains(key) || suspended && sourceLevel == 1000) continue;
            list.add(rule);
            keys.add(key);
        }
        return list.toArray(new Map[0]);
    }

    private void supplementResult(Map<PresetFeatureEnum, Object> features, Map<String, Object> r, Map<String, Object> tmp) throws Exception {
        block3: for (Map.Entry<PresetFeatureEnum, Object> entry : features.entrySet()) {
            PresetFeatureEnum key = entry.getKey();
            if (key == null) {
                throw new DWException("P.PL.500.0005", "notAgreed key in features");
            }
            switch (key) {
                case include: {
                    List value = (List)entry.getValue();
                    for (String s : value) {
                        Object o = r.get(s);
                        tmp.put(s, o);
                    }
                    continue block3;
                }
                default: {
                    throw new DWException("P.PL.500.0005", "Unexpected value: " + key);
                }
            }
        }
    }

    @Override
    public Object put(RuleDTO rule) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataMapTenantService.getTenantVersion(tenantId);
        String key = rule.getKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new DWArgumentException("key", I18nUtils.getValue((String)"preset.keyEmpty", (Object[])new Object[0]));
        }
        String activityId = rule.getActivityId();
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            throw new DWArgumentException("activityId", I18nUtils.getValue((String)"preset.activityIdEmpty", (Object[])new Object[0]));
        }
        PresetDTO preset = new PresetDTO();
        preset.setKey(key);
        preset.setDomain(PresetDomainEnum.ACTIVITY);
        preset.setDomainId(activityId);
        preset.setContent(rule.getContent());
        preset.setVersion(tenantVersion);
        preset.setName(rule.getName());
        this.presetService.put(RULE_COLNAME, preset);
        return null;
    }

    @Override
    public Object postSave(Rule rule) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataMapTenantService.getTenantVersion(tenantId);
        rule.setTenantId(tenantId);
        rule.setVersion(tenantVersion);
        this.mongoTemplate.save((Object)rule, TENANT_RULE_COLNAME);
        this.genericService.delMatch("knowledgegraph:preset:SYSTEM:" + tenantId + "*");
        return rule;
    }

    @Override
    public Object postBatchSave(List<Rule> rules) throws Exception {
        log.info("\u6279\u91cf\u4fdd\u5b58\u89c4\u5219\uff0crules\uff1a{}", (Object)JSON.toJSONString(rules));
        this.mongoTemplate.insert(rules, RULE_COLNAME);
        this.genericService.delMatch("knowledgegraph:preset*");
        return null;
    }

    @Override
    public Object postRemoveByPluginId(Rule rule) throws Exception {
        if (null != rule.getPluginId()) {
            String tenantId = ServiceUtils.getTenantId();
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)rule.getPluginId()).and("tenantId").is((Object)tenantId));
            this.mongoTemplate.remove(query, TENANT_RULE_COLNAME);
            this.genericService.delMatch("knowledgegraph:preset:SYSTEM:" + tenantId + "*");
        }
        return null;
    }

    @Override
    public Object delete(String key) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataMapTenantService.getTenantVersion(tenantId);
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new DWArgumentException("key", I18nUtils.getValue((String)"preset.keyEmpty", (Object[])new Object[0]));
        }
        this.presetService.delete(RULE_COLNAME, key, tenantVersion);
        return null;
    }

    @Override
    public Object postBatchSaveTanentRule(List<Rule> rules) throws Exception {
        log.info("\u6279\u91cf\u4fdd\u5b58\u89c4\u5219\uff0cTanent rules\uff1a{}", (Object)JSON.toJSONString(rules));
        this.mongoTemplate.insert(rules, TENANT_RULE_COLNAME);
        this.genericService.delMatch("knowledgegraph:preset*");
        return null;
    }

    @Override
    public Object postRomeveTanentRule(String pluginId) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = this.dataMapTenantService.getTenantVersion(tenantId);
        if (StringUtils.isEmpty((CharSequence)pluginId)) {
            throw new DWArgumentException("pluginId", I18nUtils.getValue((String)"preset.pluginIdEmpty", (Object[])new Object[0]));
        }
        this.presetService.deleteTanentRule(TENANT_RULE_COLNAME, pluginId, tenantVersion);
        return null;
    }
}

