/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.inner;

import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.domain.erp.Erp2FormInfo;
import com.digiwin.athena.domain.erp.ErpSyncRecord;
import com.digiwin.athena.domain.plugin.PluginBinding;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DataMapPickService
extends DataPickService {
    private static final Logger log = LoggerFactory.getLogger(DataMapPickService.class);
    @Autowired
    KmService kmService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    protected MongoTemplate mongoTemplate;
    @Autowired(required=false)
    @Qualifier(value="dataMapTenant")
    MongoTemplate mongoTemplateTenant;
    public static List<Class> tenantClasses = Arrays.asList(ErpSyncRecord.class, TaskSchedule.class, MechanismDecision.class, MechanismDecisionTarget.class, PluginRecord.class, PluginBinding.class);
    public static List<Class> sysClasses = Arrays.asList(Erp2FormInfo.class);

    public MongoTemplate systemTemplate() {
        return this.mongoTemplate;
    }

    public MongoTemplate tenantTemplate() {
        return this.mongoTemplateTenant;
    }

    public String tenantVersion(String tenantId) {
        return this.kmService.tenantVersion(tenantId);
    }

    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        return this.kmService.getCodeByTypeAndAppCode(type, app);
    }

    public boolean isTenantCol(Class c) {
        return tenantClasses.contains(c);
    }

    public boolean isSystemCol(Class c) {
        return sysClasses.contains(c);
    }
}

