/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.povo.ExecutionReq;
import com.digiwin.athena.datamap.service.inner.DataMapHelpService;
import com.digiwin.athena.datamap.service.inner.SelectService;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InnerExecutionService {
    @Autowired
    SelectService service;

    public BaseEntity findByEntity(ExecutionReq req) throws DWBusinessException {
        if (null == req.getEntityId() || req.getType() == null) {
            return null;
        }
        this.postProcessReq(req);
        Class<? extends BaseEntity> c = DataMapHelpService.entityMap.get(req.getType().toLowerCase());
        BaseEntity entity = this.service.findByEntityId(req.getEntityId(), c);
        return entity;
    }

    public Project projectDetail(ExecutionReq req) throws DWException {
        if (null == req.getEntityId()) {
            return null;
        }
        Project entity = this.service.findByEntityId(req.getEntityId(), Project.class);
        return entity;
    }

    public Object taskDetail(ExecutionReq req) throws DWException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == req.getEntityId()) {
            return map;
        }
        Task entity = this.service.findByEntityId(req.getEntityId(), Task.class);
        if (null != entity) {
            map.put("task", entity);
            if (null != entity.getFlowEntityId()) {
                FlowGraph flowGraph = this.service.findByEntityId(entity.getFlowEntityId(), FlowGraph.class);
                map.put("flow", flowGraph);
            }
        }
        return map;
    }

    public Object activityDetail(ExecutionReq req) throws DWException {
        if (null == req.getEntityId()) {
            return null;
        }
        Activity entity = this.service.findByEntityId(req.getEntityId(), Activity.class);
        return entity;
    }

    private void postProcessReq(ExecutionReq req) {
        if (null != req.getTenantId()) {
            ServiceUtils.setTenantId((String)req.getTenantId());
        }
        if (null != req.getEocId()) {
            ServiceUtils.setEoc((String)req.getEocId());
        }
    }
}

