/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.OperationUnit;
import com.digiwin.athena.datamap.povo.middleware.UserPermission;
import com.digiwin.athena.datamap.povo.middleware.UserPermissionItem;
import com.digiwin.athena.datamap.povo.rebuild.ComponentBO2;
import com.digiwin.athena.datamap.povo.rebuild.TenantAppComponentListBO2;
import com.digiwin.athena.datamap.povo.rebuild.UserComponentDto;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.spi.DatamapCacService;
import com.digiwin.athena.datamap.spi.IKnowledgeGraphService;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.TenantAppRelation;
import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class KmService {
    private static final Logger log = LoggerFactory.getLogger(KmService.class);
    public static Map<String, String> relationTypeToComponentType = new HashMap<String, String>();
    public static Map<String, String> patternToSubType = new HashMap<String, String>();
    @Autowired
    @Lazy
    DataMapPickService dataPickService;
    @Autowired
    @Lazy
    DataMapKgDataPickService dataMapKgDataPickService;
    @Autowired
    IKnowledgeGraphService knowledgeGraphService;
    @Autowired
    DatamapCacService datamapCacService;
    @Autowired
    DataMapIamService dataMapIamService;
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    @Qualifier(value="kgTenant")
    private MongoTemplate mongoTemplateTenant;

    public Map<String, String> userPermission(Set<String> appCodes, String effect0) throws DWBusinessException {
        HashMap<String, String> permissions = new HashMap<String, String>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(appCodes)) {
            return permissions;
        }
        List<UserPermission> userPermissions = this.dataMapIamService.getUserPermission(appCodes, this.userId(), this.token(), effect0);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(userPermissions)) {
            for (UserPermission up : userPermissions) {
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(up.getPermissions())) continue;
                for (UserPermissionItem item : up.getPermissions()) {
                    String target = item.getTarget();
                    String effect = item.getEffect();
                    Integer denyReason = item.getDenyReason();
                    if ("deny".equals(effect) && null != denyReason && 0 != denyReason || null == target || null == effect) continue;
                    try {
                        String[] strs = target.split(":");
                        String code = strs[strs.length - 1];
                        permissions.put(code, effect);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return permissions;
    }

    public TenantEntity tenantEntity(String tenantId) {
        if (null == tenantId) {
            return null;
        }
        TenantEntity entity = (TenantEntity)this.mongoTemplateSys.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantEntity.class);
        return entity;
    }

    public String tenantVersion(String tenantId) {
        if (null == tenantId) {
            tenantId = ServiceUtils.getTenantIdSilent();
        }
        String version = null;
        TenantEntity tenantEntity = this.tenantEntity(tenantId);
        if (null != tenantEntity && null != tenantEntity.getVersion()) {
            version = tenantEntity.getVersion();
        }
        if (StringUtils.isEmpty(version)) {
            version = "2.0";
        }
        return version;
    }

    public String tenantVersion() throws DWBusinessException {
        return this.dataPickService.tenantVersion();
    }

    public String tenantId() throws DWBusinessException {
        return ServiceUtils.getTenantId();
    }

    public String userId() throws DWBusinessException {
        return ServiceUtils.getUserId();
    }

    public String token() throws DWBusinessException {
        return ServiceUtils.getToken();
    }

    public List<String> userApps(String userId) throws DWBusinessException {
        return this.datamapCacService.getAppAuth(userId);
    }

    public Object authorizationsTenants(String tenantId) {
        return this.datamapCacService.authorizationsTenants(tenantId);
    }

    public List<String> tenantApps(String tenantId) {
        return this.datamapCacService.getAuthorizationsApplication(tenantId);
    }

    public List<String> tenantInitializedAppCodes(String tenantId) {
        List list = this.mongoTemplateSys.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantAppRelation.class);
        return list.stream().map(TenantAppRelation::getAppCode).distinct().collect(Collectors.toList());
    }

    public List<TenantAppRelation> tenantInitializedApps(String tenantId) {
        return this.mongoTemplateSys.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantAppRelation.class);
    }

    public List<TenantAppRelation> getTenantAppRelationByAppCode(List<String> appCodes) {
        if (CollectionUtils.isEmpty(appCodes)) {
            return new ArrayList<TenantAppRelation>();
        }
        return this.mongoTemplateSys.find(Query.query((CriteriaDefinition)Criteria.where((String)"appCode").in(appCodes)), TenantAppRelation.class);
    }

    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        List<String> codes = new ArrayList<String>();
        try {
            List<ApplicationRelation> relations = this.knowledgeGraphService.relations(app, type);
            if (null != relations) {
                codes = relations.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
            }
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return codes;
    }

    public List<String> commonAppCodes(String version) {
        List applications = this.mongoTemplateSys.find(Query.query((CriteriaDefinition)Criteria.where((String)"commonApp").is((Object)true).and("version").is((Object)version)), Application.class);
        return applications.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
    }

    public List<String> getCodeByTypeAndAppCodeWithComponentList(String appCode, String type, String tenantId) {
        List<String> codes = this.getCodeByTypeAndAppCode(type, appCode);
        List<String> tenantDisableComponentCodes = this.tenantDisableComponentCodes(appCode, tenantId, type, codes);
        codes.removeAll(tenantDisableComponentCodes);
        return codes;
    }

    public List<String> tenantDisableComponentCodes(String appCode, String tenantId, String type, List<String> fulllist) {
        String componentType = relationTypeToComponentType.get(type);
        Assert.notNull((Object)componentType, (String)("\u7f3a\u5c11relationType\u5230ComponentType\u7684\u6620\u5c04,relation type=" + type));
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, String> q = new HashMap<String, String>();
        q.put("appCode", appCode);
        q.put("tenantId", tenantId);
        TenantAppComponentListBO bos = this.knowledgeGraphService.findOne(BasicQuery.of(q, null), TenantAppComponentListBO.class, KnowledgeGraphDb.TENANT, "tenantAppComponentList");
        if (null == bos || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)bos.getComponents())) {
            return list;
        }
        ArrayList<String> componentList = new ArrayList<String>();
        for (ComponentBO bo : bos.getComponents()) {
            if (!bo.getType().name().equals(componentType)) continue;
            if (bo.isDisabled()) {
                list.add(bo.getCode());
                continue;
            }
            componentList.add(bo.getCode());
        }
        if (!componentList.isEmpty()) {
            for (String code : fulllist) {
                if (componentList.contains(code)) continue;
                list.add(code);
            }
        }
        return list;
    }

    public List<String> tenantDisableComponentCodes(List<String> appCodes, String tenantId, String type, Map<String, List<String>> appCodeCodes) {
        String componentType = relationTypeToComponentType.get(type);
        if (null == componentType) {
            componentType = type;
        }
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, Object> q = new HashMap<String, Object>();
        q.put("appCode", appCodes);
        q.put("tenantId", tenantId);
        List<TenantAppComponentListBO2> boss = this.knowledgeGraphService.find(BasicQuery.of(q, null), TenantAppComponentListBO2.class, KnowledgeGraphDb.TENANT, "tenantAppComponentList");
        for (TenantAppComponentListBO2 bos : boss) {
            ArrayList<String> componentList = new ArrayList<String>();
            List<String> fulllist = appCodeCodes.get(bos.getAppCode());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(fulllist) || org.apache.commons.collections.CollectionUtils.isEmpty(bos.getComponents())) continue;
            for (ComponentBO2 bo : bos.getComponents()) {
                if (!bo.getType().name().equals(componentType)) continue;
                if (bo.isDisabled()) {
                    list.add(bo.getCode());
                    continue;
                }
                componentList.add(bo.getCode());
            }
            if (componentList.isEmpty()) continue;
            for (String code : fulllist) {
                if (componentList.contains(code)) continue;
                list.add(code);
            }
        }
        return list;
    }

    public Application getAppByCodeAndType(String code, String type) throws DWBusinessException {
        Application application = null;
        ApplicationRelation relation = this.knowledgeGraphService.relation(code, type);
        if (null != relation) {
            application = this.knowledgeGraphService.application(relation.getAppCode());
        }
        return application;
    }

    public List<String> userAuthApps() throws DWBusinessException {
        return this.datamapCacService.getAppAuth(null);
    }

    public static Map<String, Object> ecoInfo(OperationUnit operationUnit) {
        HashMap<String, Object> ecoInfo = new HashMap<String, Object>();
        if (null == operationUnit) {
            return ecoInfo;
        }
        ecoInfo.put("eoc_company_id", operationUnit.getEoc_company_id());
        ecoInfo.put("eoc_site_id", operationUnit.getEoc_site_id());
        ecoInfo.put("eoc_region_id", operationUnit.getEoc_region_id());
        ecoInfo.put("operation_unit_v2", operationUnit.getOperation_unit_v2());
        return ecoInfo;
    }

    public UserComponentDto userComponents(String type, String subType, String lang) throws DWBusinessException {
        UserComponentDto dto = new UserComponentDto();
        String tenantId = this.tenantId();
        String version = this.tenantVersion();
        List<String> appCodes = this.userAuthApps();
        List<ApplicationRelation> relations = this.knowledgeGraphService.applicationRelations(appCodes, type, subType);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(relations)) {
            return null;
        }
        HashMap<String, Object> query1 = new HashMap<String, Object>();
        query1.put("code", appCodes);
        query1.put("commonApp", true);
        query1.put("version", version);
        List<Application> commonApps = this.knowledgeGraphService.find(BasicQuery.of(query1, null), Application.class, KnowledgeGraphDb.SYSTEM, "application");
        List<String> commonAppCodes = commonApps.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<Application> applicationList = this.knowledgeGraphService.applications(appCodes);
        Map applicationMap = applicationList.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> b));
        HashMap<String, ApplicationRelation> codeRelations = new HashMap<String, ApplicationRelation>();
        HashMap<String, List<String>> appCodeCodes = new HashMap<String, List<String>>();
        for (ApplicationRelation relation : relations) {
            String appCode = relation.getAppCode();
            String code = relation.getCode();
            codeRelations.put(code, relation);
            appCodeCodes.computeIfAbsent(appCode, k -> new ArrayList()).add(code);
            Application application = (Application)applicationMap.get(appCode);
            if (application == null || application.getLang() == null) continue;
            Map nameLangMap = (Map)application.getLang().get("name");
            String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
            relation.setAppName(StringUtils.isEmpty((Object)language) ? relation.getAppName() : language);
        }
        String componentType = type;
        if (null != subType) {
            componentType = subType;
        }
        List<String> disableCodes = this.tenantDisableComponentCodes(appCodes, tenantId, componentType, appCodeCodes);
        HashSet<String> codesFiltered = new HashSet<String>();
        codesFiltered.addAll(codeRelations.keySet());
        disableCodes.forEach(codesFiltered::remove);
        dto.setCodesFiltered(codesFiltered);
        dto.setCodeRelations(codeRelations);
        dto.setCommonAppCodes(commonAppCodes);
        return dto;
    }

    static {
        relationTypeToComponentType.put("task", "Project");
        relationTypeToComponentType.put("activity", "Task");
        relationTypeToComponentType.put("Task", "Project");
        relationTypeToComponentType.put("Activity", "Task");
        relationTypeToComponentType.put("base_entry", "BaseDataEntry");
        relationTypeToComponentType.put("statement", "Report");
        patternToSubType.put("DATA_ENTRY", "base_entry");
        patternToSubType.put("STATEMENT", "statement");
    }
}

