/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class SelectService {
    @Autowired
    @Qualifier(value="dataMapSystem")
    private MongoTemplate mongoTemplate;

    public <T extends TenantObject> T findByEntityId(String entityId, Class<T> c) throws DWBusinessException {
        if (null == entityId || null == c) {
            return null;
        }
        TenantObject t = (TenantObject)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId)), c);
        if (null != t) {
            List ts;
            String code = t.getCode();
            String tenantId = ServiceUtils.getTenantId();
            if (null != code && null != tenantId && (ts = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)code)), c, "tenant" + c.getSimpleName())).size() > 0) {
                ts.stream().filter(t1 -> this.eocMatch(t1)).sorted((t1, t2) -> {
                    int size1 = t1.getEocId() == null ? 0 : t1.getEocId().length();
                    int size2 = t2.getEocId() == null ? 0 : t2.getEocId().length();
                    return size1 - size2;
                }).forEach(et -> MergeUtil.mergeObject((Object)et, (Object)t));
            }
        }
        return (T)t;
    }

    public List allMatched(Map<String, Object> query, Class c, String col) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantIdSilent();
        if (null != query.get("tenantId")) {
            tenantId = (String)query.get("tenantId");
            query.remove("tenantId");
        }
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!"SYSTEM".equals(tenantId)) {
            tenantIds.add("SYSTEM");
        }
        Query query1 = new Query();
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").in(tenantIds));
        query.forEach((k, v) -> {
            if (v instanceof Collection) {
                ArrayList list = new ArrayList();
                Collection collection = (Collection)v;
                collection.forEach(ele -> list.add(ele));
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).in(list));
            } else {
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).is(v));
            }
        });
        List ts = null;
        ts = null == col ? this.mongoTemplate.find(query1, c) : this.mongoTemplate.find(query1, c, col);
        return ts;
    }

    private <T extends TenantObject> boolean eocMatch(T t) {
        if (t.getEocId() == null || t.getEocId().isEmpty()) {
            return true;
        }
        String eoc = ServiceUtils.getEoc();
        return null != eoc && eoc.startsWith(t.getEocId());
    }

    public static void main(String[] args) {
        Arrays.asList("aa", "a", "sss", "ss", "333", "").stream().sorted((s1, s2) -> s1.length() - s2.length()).forEach(s -> System.out.println((String)s));
    }
}

