/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.service.inner;

import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.domain.core.view.WordDict;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class TranslateService {
    private static final Logger log = LoggerFactory.getLogger(TranslateService.class);
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    Cache<String, Map<String, String>> langCache = Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).initialCapacity(2000).maximumSize(10000L).build();

    public String translate(String key, String locale) {
        if (null != key && null != locale) {
            String translated;
            WordDict dict;
            Map lang = (Map)this.langCache.getIfPresent((Object)key);
            if (null == lang && null != (dict = (WordDict)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"key").is((Object)key)), WordDict.class)) && null != dict.getLang()) {
                lang = dict.getLang();
                this.langCache.put((Object)key, (Object)lang);
            }
            if (null != lang && null != (translated = (String)lang.get(locale))) {
                return translated;
            }
        }
        return key;
    }

    public void clean() {
        this.langCache.cleanUp();
    }

    public void dealLangRecusive(Object entity, String locale) {
        if (null == entity || null == locale || ServiceUtils.isPrimitive(entity.getClass())) {
            return;
        }
        if (entity instanceof BaseObject) {
            this.dealLang((BaseObject)entity, locale);
            this.dealFields(entity, locale);
        } else if (entity instanceof Collection) {
            Collection collection = (Collection)entity;
            for (Object obj : collection) {
                this.dealLangRecusive(obj, locale);
            }
        } else if (entity.getClass().isArray()) {
            Object[] arr;
            for (Object obj : arr = (Object[])entity) {
                this.dealLangRecusive(obj, locale);
            }
        } else if (entity instanceof Map) {
            Map map = (Map)entity;
            if (map.get("lang") != null) {
                Map lang = (Map)map.get("lang");
                lang.forEach((k, m) -> {
                    if (null != m.get(locale)) {
                        map.put(k, m.get(locale));
                    } else if (null != m.get(locale.toLowerCase())) {
                        map.put(k, m.get(locale));
                    }
                });
            }
            HashMap translatedMap = new HashMap();
            map.forEach((k, v) -> {
                String translated;
                if (v instanceof String && null != (translated = this.translateWord((String)v, locale))) {
                    translatedMap.put(k, translated);
                }
                this.dealLangRecusive(v, locale);
            });
            map.putAll(translatedMap);
        } else {
            this.dealFields(entity, locale);
        }
    }

    private void dealFields(Object entity, String locale) {
        List fields = ServiceUtils.getFields(entity.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            try {
                Object obj = f.get(entity);
                if (obj instanceof String) {
                    Method method;
                    String translated = this.translateWord((String)obj, locale);
                    if (null == translated || null == (method = ServiceUtils.getSetMethod(entity.getClass(), (String)f.getName()))) continue;
                    try {
                        method.invoke(entity, translated);
                    }
                    catch (Exception e0) {
                        log.error(e0.getMessage(), (Throwable)e0);
                    }
                    continue;
                }
                this.dealLangRecusive(obj, locale);
            }
            catch (IllegalAccessException e) {
                log.error(e.toString());
            }
        }
    }

    private void dealLang(BaseObject entity, String locale) {
        Map lang;
        if (null != entity && null != locale && null != (lang = entity.getLang())) {
            lang.forEach((k, v) -> {
                String langName;
                if (v != null && (langName = (String)v.get(locale)) != null) {
                    Method method = ServiceUtils.getSetMethod(entity.getClass(), (String)k);
                    if (null != method) {
                        try {
                            method.invoke((Object)entity, langName);
                        }
                        catch (Exception e) {
                            log.error(e.toString());
                        }
                    } else {
                        log.warn("can not find set method by class {} and filed {}", (Object)entity.getClass().getName(), k);
                    }
                }
            });
        }
    }

    private String translateWord(String str, String locale) {
        String key;
        if (null != str && str.startsWith("#{") && str.endsWith("}") && StringUtils.isNotEmpty((CharSequence)(key = str.substring(2, str.length() - 1).trim()))) {
            return this.translate(key, locale);
        }
        return null;
    }
}

