/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.povo.CardGroupGroup;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AtmcService {
    private static final Logger log = LoggerFactory.getLogger(AtmcService.class);
    @Value(value="${atmcUrl}")
    private String atmcUrl;
    @Autowired
    private RestTemplate restTemplate;

    public Object cleanCache() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DapResponse resp = DataMapUtils.request(this.atmcUrl + "/v1/cache/reset", "get", params);
        return resp.getResponse();
    }

    public List<CardGroupGroup> getGroupDimension(String routerKey) {
        String tenantToken = ServiceUtils.getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("token", tenantToken);
        if (StringUtils.isNotEmpty((CharSequence)routerKey)) {
            headers.add("routerKey", routerKey);
        }
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        log.info("getGroupDimension tenantId:{}, url:{}", (Object)routerKey, (Object)(this.atmcUrl + "/api/atmc/v1/backlog/group/dimension"));
        ResponseEntity resEntity = this.restTemplate.exchange(this.atmcUrl + "/api/atmc/v1/backlog/group/dimension", HttpMethod.GET, requestEntity, DapResponse.class, new Object[0]);
        DapResponse body = (DapResponse)resEntity.getBody();
        log.info("getGroupDimension result:{}", (Object)body);
        List cardGroupGroups = JSONObject.parseArray((String)JSON.toJSONString(body.getResponse()), CardGroupGroup.class);
        return cardGroupGroups;
    }
}

