/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DatamapEocService {
    private static final Logger log = LoggerFactory.getLogger(DatamapEocService.class);
    @Value(value="${eocUrl}")
    private String eocUrl;
    @Value(value="${iamApToken}")
    private String appToken = null;

    public Object eocInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DapResponse resp = DataMapUtils.request(this.eocUrl + "/api/eoc/v2/corp/all", "get", params);
        return resp.getData();
    }

    public void syncDuty(Map<String, Object> params) {
        this.requestEoc("/api/eoc/v2/duty", "post", params);
    }

    public void synclevel(Map<String, Object> params) {
        this.requestEoc("/api/eoc/v2/emp/level", "post", params);
    }

    public Map requestEoc(String url, String method, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-app", this.appToken);
        String resp = DataMapUtils.requestString(this.eocUrl + url, method, params, headers);
        return (Map)JSONObject.parseObject((String)resp, Map.class);
    }
}

