/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.service.impl.RuleService;
import com.digiwin.athena.preset.Rule;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PresetLibraryService {
    private static final Logger log = LoggerFactory.getLogger(PresetLibraryService.class);
    @Autowired
    RuleService ruleService;
    protected static final String RULE_COLNAME = "rules";

    public Object saveRule(Rule rule) {
        try {
            return this.ruleService.postSave(rule);
        }
        catch (Exception e) {
            log.error("saveRule error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Object cleanRule(String pluginId) {
        if (null == pluginId) {
            return null;
        }
        Rule rule = new Rule();
        rule.setPluginId(pluginId);
        try {
            return this.ruleService.postRemoveByPluginId(rule);
        }
        catch (Exception e) {
            log.error("cleanRule error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Object queryRule(String taskCode) {
        try {
            int count = -1;
            return this.ruleService.postQuery(taskCode, count);
        }
        catch (Exception e) {
            log.error("queryRule error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Rule> rules(String taskCode) {
        Map resp = (Map)this.queryRule(taskCode);
        if (null == resp) {
            return null;
        }
        List rules = JSON.parseArray((String)JSON.toJSONString(resp.get(RULE_COLNAME)), Rule.class);
        return rules;
    }
}

