/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static ThreadLocal<String> currentLocale = new ThreadLocal();

    public static boolean isPrimitive(Class<?> c) {
        return c != null && (c.isPrimitive() || Number.class.isAssignableFrom(c) || Boolean.class.equals(c) || Character.class.isAssignableFrom(c) || CharSequence.class.isAssignableFrom(c));
    }

    public static Method getSetMethod(Class objectClass, String fieldName) {
        try {
            Class[] parameterTypes = new Class[1];
            Field field = objectClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            StringBuffer sb = new StringBuffer();
            sb.append("set");
            sb.append(fieldName.substring(0, 1).toUpperCase());
            sb.append(fieldName.substring(1));
            Method method = objectClass.getMethod(sb.toString(), parameterTypes);
            return method;
        }
        catch (NoSuchFieldException e0) {
            if (objectClass.getSuperclass() != null && !objectClass.getSuperclass().equals(Object.class)) {
                return CommonUtils.getSetMethod(objectClass.getSuperclass(), fieldName);
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return null;
    }

    public static Method getGetMethod(Class objectClass, String fieldName) {
        if (null == objectClass || null == fieldName) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("get");
        sb.append(fieldName.substring(0, 1).toUpperCase());
        sb.append(fieldName.substring(1));
        Method method = null;
        try {
            method = objectClass.getMethod(sb.toString(), null);
        }
        catch (NoSuchMethodException e) {
            log.error(e.toString());
        }
        return method;
    }

    public static List<Field> getFields(Class<?> clazz) {
        Class<?> c = clazz;
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            Field[] fs;
            for (Field f : fs = c.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || CommonUtils.isContain(fields, f)) continue;
                fields.add(f);
            }
        } while ((c = c.getSuperclass()) != null);
        return fields;
    }

    public static Field getField(Class<?> clazz, String name) {
        Class<?> c = clazz;
        do {
            Field[] fs;
            for (Field f : fs = c.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || !name.equals(f.getName())) continue;
                return f;
            }
        } while ((c = c.getSuperclass()) != null);
        return null;
    }

    public static boolean isContain(List<Field> fieldList, Field field) {
        for (Field temp : fieldList) {
            if (!temp.getName().equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentLocale() {
        String localeString = null;
        Map headers = DWServiceContext.getContext().getRequestHeader();
        if (headers != null && headers.containsKey("locale")) {
            localeString = (String)headers.get("locale");
        }
        return localeString;
    }

    public static void setLocale(String locale) {
        currentLocale.set(locale);
    }

    public static String getLocale() {
        return currentLocale.get();
    }

    public static String loadFile(String fileName) {
        try {
            String text = FileUtils.readFileToString((File)ResourceUtils.getFile((URL)CommonUtils.class.getResource("/files/" + fileName)), (String)"utf-8");
            return text;
        }
        catch (IOException e) {
            log.error(e.toString());
            return null;
        }
    }

    public static String loadStream(String fileName) {
        try {
            String text = IOUtils.toString((URL)CommonUtils.class.getResource("/files/" + fileName), (String)"utf-8");
            return text;
        }
        catch (IOException e) {
            log.error(e.toString());
            return null;
        }
    }

    public static String content(String name, Map<String, String> param) {
        String file;
        String replaced = file = CommonUtils.loadStream(name);
        for (Map.Entry<String, String> entry : param.entrySet()) {
            String pattern = "#" + entry.getKey() + "#";
            String value = entry.getValue();
            if (value.startsWith("$")) {
                value = "\\" + value;
            }
            replaced = replaced.replaceAll(pattern, value);
        }
        return replaced;
    }

    public static Object entity(String name, Map<String, String> param) {
        String replaced = CommonUtils.content(name, param);
        JSONObject entities = JSON.parseObject((String)replaced);
        return entities;
    }

    public static <T> T entity(String name, Map<String, String> param, Class<T> c) {
        String replaced = CommonUtils.content(name, param);
        Object entities = JSON.parseObject((String)replaced, c);
        return (T)entities;
    }

    public static List entities(String name, Map<String, String> param) {
        String replaced = CommonUtils.content(name, param);
        JSONArray entities = JSON.parseArray((String)replaced);
        return entities;
    }

    public static <T> List<T> entities(String name, Map<String, String> param, Class c) {
        String replaced = CommonUtils.content(name, param);
        List entities = JSON.parseArray((String)replaced, (Class)c);
        return entities;
    }

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return null;
        }
        int totalSize = datas.size();
        int count = totalSize % splitSize == 0 ? totalSize / splitSize : totalSize / splitSize + 1;
        ArrayList<List<T>> rows = new ArrayList<List<T>>(splitSize);
        for (int i = 0; i < count; ++i) {
            List<T> cols = datas.subList(i * splitSize, i == count - 1 ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    public static void main(String[] args) {
        String content = CommonUtils.loadStream("DDSM/Activity.json");
        System.out.println(content);
    }
}

