/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.utils.LanguageUtil;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.luhuiguo.chinese.ChineseUtils;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DataMapTranslateUtils {
    private static final Logger log = LoggerFactory.getLogger(DataMapTranslateUtils.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${translateUrl}/restful/service/translater/IDWTranslateService/translateCustom")
    private String requestUrl;
    @Value(value="${translateUrl}/restful/service/translater/IDWTranslateCustomService/km")
    private String requestKmUrl;
    private static final String REQUEST_URL = "https://translation.digiwincloud.com/restful/service/translater/IDWTranslateService/translateCustom";
    private static final String KEY = "key";
    @Autowired
    private DWHttpClient dwHttpClient;

    public String translateContentToTw(Object content) {
        HttpPost httpPost = new HttpPost(this.requestUrl);
        httpPost.setHeader("Content-Type", MediaType.APPLICATION_JSON.toString());
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", (Object)ImmutableMap.of((Object)KEY, (Object)content));
        requestBody.put("convertTypes", (Object)new String[]{"zh2Hant"});
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.create((String)"application/json", (Charset)Charsets.UTF_8));
        httpPost.setEntity((HttpEntity)requestEntity);
        try {
            HttpEntity entity;
            HttpResponse response = this.dwHttpClient.execute((HttpUriRequest)httpPost, new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value() && (entity = response.getEntity()) != null) {
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject result = JSON.parseObject((String)responseString);
                Object langData = result.getJSONObject("response").getJSONObject("data").getOrDefault((Object)"lang", null);
                if (null == langData) {
                    Object responseData = result.getJSONObject("response").getJSONObject("data").get((Object)KEY);
                    LanguageUtil.processLocaleLanguage(responseData, "zh_TW");
                    DataMapTranslateUtils.processJson(responseData);
                    return responseData.toString();
                }
                return result.getJSONObject("response").getJSONObject("data").getJSONObject("lang").getJSONObject(KEY).getString("zh_TW");
            }
        }
        catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}", (Throwable)e);
        }
        return ChineseUtils.toTraditional((String)JSON.toJSONString((Object)content));
    }

    public String translateContent(Object content) throws DWBusinessException {
        HttpPost httpPost = new HttpPost(this.requestUrl);
        httpPost.setHeader("Content-Type", MediaType.APPLICATION_JSON.toString());
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", (Object)ImmutableMap.of((Object)KEY, (Object)content));
        requestBody.put("convertTypes", (Object)new String[]{"zh2Hant", "zh2Hans"});
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.create((String)"application/json", (Charset)Charsets.UTF_8));
        httpPost.setEntity((HttpEntity)requestEntity);
        try {
            HttpEntity entity;
            HttpResponse response = this.dwHttpClient.execute((HttpUriRequest)httpPost, new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value() && (entity = response.getEntity()) != null) {
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject result = JSON.parseObject((String)responseString);
                Object responseData = result.getJSONObject("response").getJSONObject("data").get((Object)KEY);
                return responseData.toString();
            }
        }
        catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}", (Throwable)e);
        }
        throw new DWBusinessException("\u6570\u636e\u8f6c\u591a\u8bed\u8a00\u51fa\u73b0\u95ee\u9898");
    }

    public JSONObject translateContent(String key, Object content, String[] translateTypes) throws DWBusinessException {
        HttpPost httpPost = new HttpPost(this.requestUrl);
        httpPost.setHeader("Content-Type", MediaType.APPLICATION_JSON.toString());
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", (Object)ImmutableMap.of((Object)key, (Object)content));
        requestBody.put("convertTypes", (Object)translateTypes);
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.create((String)"application/json", (Charset)Charsets.UTF_8));
        httpPost.setEntity((HttpEntity)requestEntity);
        try {
            HttpEntity entity;
            HttpResponse response = this.dwHttpClient.execute((HttpUriRequest)httpPost, new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value() && (entity = response.getEntity()) != null) {
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject result = JSON.parseObject((String)responseString);
                return result.getJSONObject("response").getJSONObject("data").getJSONObject("lang");
            }
        }
        catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}", (Throwable)e);
        }
        throw new DWBusinessException("\u6570\u636e\u8f6c\u591a\u8bed\u8a00\u51fa\u73b0\u95ee\u9898");
    }

    private static void processJson(Object json) {
        if (json instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)json;
            if (jsonObj.containsKey((Object)"lang")) {
                jsonObj.remove((Object)"lang");
            }
            if (jsonObj.containsKey((Object)"language")) {
                jsonObj.remove((Object)"language");
            }
            jsonObj.forEach((key, value) -> DataMapTranslateUtils.processJson(value));
        } else if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            jsonArray.forEach(DataMapTranslateUtils::processJson);
        }
    }

    public Object translateSmartDataContent(Object content) throws DWBusinessException {
        HttpPost httpPost = new HttpPost(this.requestKmUrl);
        httpPost.setHeader("Content-Type", MediaType.APPLICATION_JSON.toString());
        JSONObject requestBody = new JSONObject();
        requestBody.put("content", (Object)ImmutableMap.of((Object)KEY, (Object)content));
        requestBody.put("convertTypes", (Object)new String[]{"zh2Hant", "zh2Hans"});
        StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.create((String)"application/json", (Charset)Charsets.UTF_8));
        httpPost.setEntity((HttpEntity)requestEntity);
        try {
            HttpEntity entity;
            HttpResponse response = this.dwHttpClient.execute((HttpUriRequest)httpPost, new DWRequestOption(false));
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.OK.value() && (entity = response.getEntity()) != null) {
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject result = JSON.parseObject((String)responseString);
                return result.getJSONObject("response").getJSONObject("data").get((Object)KEY);
            }
        }
        catch (Exception e) {
            log.error("TranslateUtils.translateContent method error:{}", (Throwable)e);
        }
        throw new DWBusinessException("\u6570\u636e\u8f6c\u591a\u8bed\u8a00\u51fa\u73b0\u95ee\u9898");
    }
}

