/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.utils;

import com.digiwin.athena.domain.core.app.ApplicationRelation;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExporter {
    public void exportToExcel(List<ApplicationRelation> applicationRelations) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("Application Relations");
        Row headerRow = sheet.createRow(0);
        headerRow.createCell(0).setCellValue("App Code");
        headerRow.createCell(1).setCellValue("App Name");
        headerRow.createCell(2).setCellValue("Code");
        headerRow.createCell(3).setCellValue("Name");
        int rowNum = 1;
        for (ApplicationRelation relation : applicationRelations) {
            Row row = sheet.createRow(rowNum++);
            row.createCell(0).setCellValue(relation.getAppCode());
            row.createCell(1).setCellValue(relation.getAppName());
            row.createCell(2).setCellValue(relation.getCode());
            row.createCell(3).setCellValue(relation.getName());
        }
        try (FileOutputStream outputStream = new FileOutputStream("application_relations.xlsx");){
            workbook.write((OutputStream)outputStream);
        }
    }
}

