/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.utils;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LanguageUtil {
    private static final Logger log = LoggerFactory.getLogger(LanguageUtil.class);

    public static void processLocaleLanguage(Object data, String locale) throws IllegalAccessException, NoSuchFieldException {
        if (data == null || StringUtils.isEmpty((Object)locale)) {
            return;
        }
        Map language = null;
        if (data instanceof Map) {
            for (Map.Entry entry : ((Map)data).entrySet()) {
                if (((String)entry.getKey()).equals("lang") || entry.getValue() == null || LanguageUtil.isPrimitive(entry.getValue().getClass()) || LanguageUtil.isNumber(String.valueOf(entry.getValue())) || LanguageUtil.isPrimitiveArray(entry.getValue())) continue;
                if (entry.getValue() instanceof String) {
                    Map lang;
                    language = (Map)((Map)data).get("lang");
                    if (language == null || language.isEmpty() || !language.containsKey(entry.getKey()) || !(lang = (Map)language.get(entry.getKey())).containsKey(locale)) continue;
                    entry.setValue(lang.get(locale));
                    continue;
                }
                LanguageUtil.processLocaleLanguage(entry.getValue(), locale);
            }
        } else if (data instanceof List) {
            for (Object item : (List)data) {
                LanguageUtil.processLocaleLanguage(item, locale);
            }
        } else {
            if (data == null) {
                return;
            }
            if (LanguageUtil.isPrimitive(data.getClass())) {
                return;
            }
            if (LanguageUtil.isNumber(String.valueOf(data))) {
                return;
            }
            if (data instanceof String) {
                return;
            }
            if (LanguageUtil.isPrimitiveArray(data.getClass())) {
                return;
            }
            if (data.getClass().isEnum()) {
                return;
            }
            Field langField = null;
            try {
                langField = data.getClass().getDeclaredField("lang");
                langField.setAccessible(true);
                language = (Map)langField.get(data);
            }
            catch (NoSuchFieldException item) {
                // empty catch block
            }
            try {
                if (langField == null) {
                    langField = data.getClass().getSuperclass().getDeclaredField("lang");
                    langField.setAccessible(true);
                    language = (Map)langField.get(data);
                }
            }
            catch (NoSuchFieldException item) {
                // empty catch block
            }
            Class<?> clazz = data.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                Map lang;
                String fieldName;
                field.setAccessible(true);
                if (field.isSynthetic() || LanguageUtil.isPrimitive(field.getType()) || LanguageUtil.isPrimitiveArray(field.getType())) continue;
                if (field.getType().equals(String.class)) {
                    fieldName = field.getName();
                    if (language == null || language.isEmpty() || !language.containsKey(fieldName) || !(lang = (Map)language.get(fieldName)).containsKey(locale)) continue;
                    field.set(data, lang.get(locale));
                    continue;
                }
                if (field.get(data) instanceof String) {
                    fieldName = field.getName();
                    if (language == null || language.isEmpty() || !language.containsKey(fieldName) || !(lang = (Map)language.get(fieldName)).containsKey(locale)) continue;
                    field.set(data, lang.get(locale));
                    continue;
                }
                if (field.get(data) instanceof List) {
                    for (Object item : (List)field.get(data)) {
                        LanguageUtil.processLocaleLanguage(item, locale);
                    }
                    continue;
                }
                if (field.get(data) instanceof Object) {
                    LanguageUtil.processLocaleLanguage(field.get(data), locale);
                    continue;
                }
                if (!field.getType().equals(Object.class)) continue;
                LanguageUtil.processLocaleLanguage(field.get(data), locale);
            }
        }
    }

    public static boolean isPrimitive(Class clz) {
        try {
            if (clz.isPrimitive()) {
                return true;
            }
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isNumber(String str) {
        String reg = "^-?[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    public static boolean isPrimitiveArray(Object array) {
        if (array instanceof boolean[]) {
            return true;
        }
        if (array instanceof byte[]) {
            return true;
        }
        if (array instanceof char[]) {
            return true;
        }
        if (array instanceof double[]) {
            return true;
        }
        if (array instanceof float[]) {
            return true;
        }
        if (array instanceof int[]) {
            return true;
        }
        if (array instanceof long[]) {
            return true;
        }
        return array instanceof short[];
    }
}

