/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.datamap.povo.ActivityInputData;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.activity.Activity;
import java.util.List;
import java.util.Optional;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;

public interface ActivityRepository
extends Neo4jRepository<Action, Long> {
    @Query(value="MATCH (task:Task{code:$1,version:$3})-[:Contains]->(t:Activity {code:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    public Optional<ActivityInputData> getActivityInputData(String var1, String var2, String var3, String var4);

    @Query(value="match(a:Activity) where a.category = 'ABI-STATEMENT' return distinct  a.code as code")
    public List<String> getAllABiReportCodes();

    @Query(value="MATCH (activity:Activity) where activity.code = $0 and activity.version = $1 and (activity.tenantId in ['SYSTEM',$2] or activity.tenantId is null or $2 in activity.inclusionTenant)return activity")
    public List<Activity> getActivityByCodeAndVersion(String var1, String var2, String var3);

    @Query(value="match (a:Activity{code:$1,version:$2}) where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) return a")
    public List<Activity> getActivityByCode(String var1, String var2, String var3);

    @Query(value="match (a:Activity{nameSpace:'common'}) where a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant return a")
    public List<Activity> getCommonBaseData(String var1);

    @Query(value="match (a:Activity{pattern:$1,version:$2}) where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) and a.code in $3  return a")
    public List<Activity> getActivitiesByPattern(String var1, String var2, String var3, List<String> var4);
}

