/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.monitorRule.MonitorRule;
import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface MonitorRuleRepository
extends Neo4jRepository<MonitorRule, Long> {
    public List<MonitorRule> findByCodeAndVersion(String var1, String var2);

    public List<MonitorRule> findByVersion(String var1);

    @Query(value="MATCH (rule:MonitorRule{commonApp:true}) where rule.version = $0 return rule")
    public List<MonitorRule> getCommonByVersion(String var1);

    @Deprecated
    @Query(value="MATCH (rule:CustomizationMonitorRule) where rule.code = $0 and rule.level = 'tenant' and rule.levelId = $1 and rule.version = $2 and rule.type = 'add' return rule")
    public List<MonitorRule> getAddedCustomByCode(String var1, String var2, String var3);

    @Query(value="MATCH (m:Mechanism)-[:Contains]->(rule:MonitorRule) where m.key=$0 return rule.code")
    public List<String> getCodeByMechainismCode(String var1);

    @Query(value="MATCH (m:Mechanism{version:$1})-[:Contains]->(rule:MonitorRule) where m.key=$0 return rule.code")
    public List<String> getCodeByMechainismCode(String var1, String var2);

    @Query(value="MATCH (rule:MonitorRule) where rule.code in $0 and rule.version = $1 and rule.autoRun = true and (rule.tenantId in ['SYSTEM',$2] or rule.tenantId is null or $2 in rule.inclusionTenant) return rule ")
    public List<MonitorRule> queryAutoRunMonitorRuleList(List<String> var1, String var2, String var3);

    @Query(value="MATCH (rule:MonitorRule) return distinct rule.code as code , rule.category as category, rule.backtrackDate as backtrackDate, rule.dataCheck as dataCheck")
    public List<Map> getAllMonitorRuleCodes();
}

