const KM_HOOK_GLOBAL = options.dataStore.get('km_hook_global');
console.log(KM_HOOK_GLOBAL, 1000);

function createRowMap(dataMap) {
    const rowMap = new Map();
    let index = 0;
    dataMap.forEach((data) => {
        const type = data.type;
        const api = data.api;
        const dataList = data.data;
        dataList.forEach((row) => {
            console.log(row,KM_HOOK_GLOBAL.GET_ROW_KEY_FN(row.key), 1000.11);
            index++;
            rowMap.set(KM_HOOK_GLOBAL.GET_ROW_KEY_FN(row.key), {
                type: type,
                api: api,
                data: row,
            });
        });
    });
    console.log(dataMap, 1111);
    console.log(rowMap, 1112);
    return rowMap;
}
function initData(rowMap) {
    const recommendMap = new Map();
    if (rowMap.size === 0) return;
    const tableData = component.getAllRowData();
    console.log(tableData, 1113);

    for (let index = 0; index < tableData.length; index++) {
        const row = tableData[index];
        console.log(row, 1114);
        console.log(rowMap.size,rowMap.keys(),  KM_HOOK_GLOBAL.GET_ROW_KEY_FN(row.value),1115);
        const currentRowKey = KM_HOOK_GLOBAL.GET_ROW_KEY_FN(row.value);
        if (rowMap.has(currentRowKey)) {
            const currentData = rowMap.get(currentRowKey);
            console.log(currentData, 1116);
            const apiFieldValueParam = KM_HOOK_GLOBAL.TARGET_DATA;
            console.log(apiFieldValueParam, 1117);
            const field_value =
                currentData.type === 'api'
                    ? currentData.data.field_value
                    : apiFieldValueParam[currentData.api];
            if (field_value.length === 1) {
                const columm = findComponentType(KM_HOOK_GLOBAL.FIELD_PARAM);
                const isMultiple = columm.editorTypes.includes('SELECT_MULTIPLE');
                let fieldValue = '';
                if (isMultiple) {
                    fieldValue = Array.isArray(field_value[0].value)
                        ? field_value[0].value
                        : Array.of(field_value[0].value);
                } else {
                    fieldValue = field_value[0].value;
                }
                console.log(fieldValue, 1117.1);
                component.operateRow(
                    {
                        type: 'patch',
                        data: {
                            [KM_HOOK_GLOBAL.FIELD_PARAM]: fieldValue,
                        },
                    },
                    row
                );
            } else if (field_value.length > 1) {
                recommendMap.set(
                    KM_HOOK_GLOBAL.GET_ROW_KEY_FN(currentData.data.key),
                    field_value
                );
            }
            rowMap.delete(KM_HOOK_GLOBAL.GET_ROW_KEY_FN(row.value));
        }
        if (rowMap.size === 0) {
            break;
        }
    }
    options.dataStore.observableObj({key: 'km_metaData', target: recommendMap});
    const km_row_data_change = options.dataStore.get('km_row_data_change');
    if (km_row_data_change) {
        km_row_data_change.isChange = true;
    }
}

function findComponentType(field) {
    console.log(1117.111);
    let temp = null;
    const columns = component.getModel().columnDefs;
    for (let index = 0; index < columns.length; index++) {
        const item = columns[index];
        if (item.schemas.includes(field)) {
            temp = item;
            break;
        }
    }
    return temp;
}

function processData(dataMap) {
    const rowMap = createRowMap(dataMap);
    initData(rowMap);
}

const baseUrl =
    options.utils.espApi.configService._config.themeMapUrl + '/knowledgegraph/mechanismDesign/queryApiInfo';
console.log(baseUrl, 1118);

const apiList = KM_HOOK_GLOBAL.HOOK_API_LIST;
console.log(apiList, 1119);

const apiData = [];
var apiFinishedNum = 0;

try {
    console.log(KM_HOOK_GLOBAL.CURRENT_APP_TYPE, KM_HOOK_GLOBAL.APP_TYPES.STANDARD, 1119.11);
    if (
        (KM_HOOK_GLOBAL.CURRENT_APP_TYPE === KM_HOOK_GLOBAL.APP_TYPES.STANDARD &&
            component.frontPagination) || KM_HOOK_GLOBAL.CURRENT_APP_TYPE === KM_HOOK_GLOBAL.APP_TYPES.HALF_CUSTOM
    ) {
        console.log(apiList,1119.22);
        component.setLoading(true);
        apiList.forEach((api, index) => {
            //标准应用需提交页面数据
            if (KM_HOOK_GLOBAL.CURRENT_APP_TYPE === KM_HOOK_GLOBAL.APP_TYPES.STANDARD) {
                api.params.req.tableData = options.utils.lodash.cloneDeep(
                    parentData[KM_HOOK_GLOBAL.TABLE_DATA_KEY]
                );
            }
            console.log(api.params,1119.33);
            // 获取任务卡表格数据并存入
            options.utils.http.post(baseUrl, api.params).subscribe(
                (res) => {
                    console.log(res, 1121);
                    const meta_data_list = res.data.meta_data_list;
                    console.log(meta_data_list, 1122);
                    apiData[index] = {
                        api: api.params.req.api,
                        type: api.type,
                        data: meta_data_list,
                    };
                    apiFinishedNum++;
                    if (apiFinishedNum === apiList.length) {
                        console.log(apiData, 1123);
                        processData(apiData);
                        component.setLoading(false);
                    }
                },
                (err) => {
                    apiData[index] = {
                        api: api.params.api,
                        type: api.type,
                        data: [],
                    };
                    apiFinishedNum++;
                    if (apiFinishedNum === apiList.length) {
                        console.log(apiData, 1123);
                        processData(apiData);
                        component.setLoading(false);
                    }
                }
            );
        });
    }
} catch (e) {
    component.setLoading(false);
}
