const KM_HOOK_GLOBAL = {
    CURRENT_APP_TYPE: 'hookCallApiAppType',
    TABLE_DATA_KEY: 'hookCallApiTableDataKey',
    KEY_FIELD_NAME_LIST: JSON.parse('hookCallApiKeyFieldNameList'),
    APP_TYPES: {
        STANDARD: 'standard',
        HALF_CUSTOM: 'half_custom',
    },
    FIELD_PARAM: 'hookCallApiFieldParam',
    TARGET_DATA: 'hookCallApiFieldValueParam',
    HOOK_API_LIST: JSON.parse('hookCallApiApiListParam'),
    GET_ROW_KEY_FN: getRowKeyValue,
};

// 获取当前数据唯一键值
function getRowKeyValue(row) {
    const keys = KM_HOOK_GLOBAL.KEY_FIELD_NAME_LIST;
    return keys.reduce((str, key) => {
        return str + row[key];
    }, '');
}

// 缓存全局参数
options.dataStore.observableObj({
    key: 'km_hook_global',
    target: KM_HOOK_GLOBAL,
});

options.dataStore.observableObj({
    key: 'km_row_data_change',
    target: { isChange: false },
});