package com.digiwin.athena.datamap.actions.handlers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionHandler;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.spi.EspService;
import com.digiwin.athena.datamap.supports.EspBody;
import com.digiwin.athena.datamap.supports.EspRequest;
import com.digiwin.athena.datamap.utils.CommonUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-02-16 15:53
 **/

public abstract class AbstractActionHandler implements ActionHandler {

    @Autowired
    EspService espService;

    protected ActionResp callEsp(EspRequest request) {
        ActionResp resp = new ActionResp();
        EspBody body = espService.invokeSync(request);
        resp.setSuccess(body.getSuccess());
        if (body.getSuccess() && null != body.getStd_data() && null != body.getStd_data().getParameter()) {
            resp.setData(body.getStd_data().getParameter());
        } else {
            resp.setMsg(body.getMsg());
            Map<String, Object> rows = new HashMap<>();
            rows.put("rows", new JSONArray[0]);
            resp.setData(rows);
            resp.setSuccess(Boolean.FALSE);
        }
        return resp;
    }

    protected Map<String, String> E10headers() {
        Map<String, String> headers = new HashMap<>();
        // headers.put("digi-host","acct");
        return headers;
    }

    // do test
    private void callTestEsp(String serviceName) {
        String fileName;
        ActionResp resp = new ActionResp();
        if (Objects.equals(serviceName, ActionConstants.e10_oapi_schema_data_get)) {
            fileName = "ysj.json";
        } else if (Objects.equals(serviceName, ActionConstants.e10_oapi_easyflow_object_list_data_query_get)) {
            fileName = "jczy.json";
        } else if (Objects.equals(serviceName, ActionConstants.e10_oapi_doc_list_data_query_get)) {
            fileName = "djxz.json";
        } else if (Objects.equals(serviceName, ActionConstants.e10_oapi_company_list_data_query_get)) {
            fileName = "company.json";
        } else if (Objects.equals(serviceName, ActionConstants.e10_oapi_plant_list_data_query_get)) {
            fileName = "plant.json";
        } else if (Objects.equals(serviceName, ActionConstants.e10_oapi_sales_center_list_data_query_get)) {
            fileName = "sales.json";
        } else if (Objects.equals(serviceName, ActionConstants.e10_oapi_supply_center_list_data_query_get)) {
            fileName = "supply.json";
        } else {
            fileName = "ysj.json";
        }

        String files = CommonUtils.loadStream("test" + "/" + fileName);
        EspBody body = JSON.parseObject(files, EspBody.class);
        body.setSuccess(Boolean.TRUE);
        resp.setSuccess(Boolean.TRUE);
    }

    @Override
    public boolean accept(ActionReq actionReq) {
        if (null != actionId() && null != actionReq.getActionId()) {
            return actionId().equals(actionReq.getActionId());
        }
        return false;
    }

    protected abstract String actionId();
}
