package com.digiwin.athena.datamap.actions.handlers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.datamap.actions.ActionConstants;
import com.digiwin.athena.datamap.actions.ActionContext;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.supports.EspBody;
import com.digiwin.athena.datamap.supports.EspRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * APC
 **/
@Service
@Order(10)
public class Esp_bm_dpsc_working_day_plan_get extends AbstractActionHandler {

    @Override
    public String actionId() {
        return ActionConstants.bm_dpsc_working_day_plan_get;
    }

    @Override
    public String description() {
        return "取得生产日计划信息";
    }

    @Override
    protected ActionResp callEsp(EspRequest request) {
        ActionResp resp = new ActionResp();
        EspBody body = espService.invokeSync(request);
        resp.setSuccess(body.getSuccess());
        if (body.getSuccess() && null != body.getStd_data() && null != body.getStd_data().getParameter()) {
            Map<String, Object> parameter = body.getStd_data().getParameter();
            Object wo_op_dispatch_data = parameter.get("apc_day_plan_data");
            if (ObjectUtils.isEmpty(wo_op_dispatch_data)) {
                resp.setData(new JSONArray[0]);
            } else {
                JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(wo_op_dispatch_data));
                Set<String> res = new HashSet<>();
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject responseJSON = jsonArray.getJSONObject(i);
                    if (responseJSON.containsKey("op_no") && !"2".equals(responseJSON.get("wo_property"))) {
                        res.add(responseJSON.getString("op_no"));
                    }
                }
                resp.setData(res);
            }
        } else {
            resp.setMsg(body.getMsg());
            resp.setData(new JSONArray[0]);
            resp.setSuccess(Boolean.FALSE);
        }
        return resp;
    }

    @Override
    public ActionResp handler(ActionContext context) {
        // api及参数替换
        Map<String, Object> params = new HashMap<>();
        params.put("apc_day_plan_data", context.getActionReq().getParams().get("day_plan_data"));
        EspRequest request = EspRequest.of(ActionConstants.apc_working_day_plan_dispatch_info_get,
                context.getActionReq().getProduct(), params, super.E10headers());
        request.setHostProd("EAS");
        return callEsp(request);
    }

}
