package com.digiwin.athena.datamap.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

@Configuration
@EnableScheduling
public class DatamapThreadPoolConfiguration {

    /**
     * 无阻塞队列线程池，使用默认拒绝策略
     * 使用场景：异步任务需要等待所有任务返回结果才能使用该线程池
     * @return 无阻塞队列线程池
     */
    @Bean("noQueueExecutor")
    //@Primary
    public ThreadPoolTaskExecutor noQueueExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        // 核心线程数 当前机器核心数
        executor.setCorePoolSize(20);
        // 最大线程数=核心线程数
        executor.setMaxPoolSize(20);
        // 队列长度
        executor.setQueueCapacity(0);
        // 允许线程空闲时间
        executor.setKeepAliveSeconds(60);
        // 线程池名称前缀
        executor.setThreadNamePrefix("noQueueExecutor");
        // 自定义拒绝策略
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

}
