package com.digiwin.athena.datamap.configuration;

import com.digiwin.athena.kmservice.constants.DataMapDb;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import com.mongodb.MongoClientSettings.Builder;

@Configuration
public class MultiMongoSourceConfiguration {
    @Autowired
    MongoClient mongo;
    @Autowired
    MongoConverter converter;



    @Bean("dataMapSystem")
    public MongoTemplate dataMapSystem(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, DataMapDb.DATAMAP.getValue());
        System.out.println("systemdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate(mongoDbFactory,converter);
    }


    @Bean("dataMapTenant")
    public MongoTemplate dataMapTenant(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, DataMapDb.DATAMAPTENANT.getValue());
        System.out.println("tenantdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate(mongoDbFactory, converter);
    }

    @Bean("kgSystem")
    public MongoTemplate kgSystem(){
        SimpleMongoDbFactory mongoDbFactorySys = new SimpleMongoDbFactory(mongo, KnowledgeGraphDb.SYSTEM.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate(mongoDbFactorySys, converter);
        return mongoTemplateSys;
    }

    @Bean("kgTenant")
    public MongoTemplate kgTenant(){
        SimpleMongoDbFactory mongoDbFactorySys = new SimpleMongoDbFactory(mongo, KnowledgeGraphDb.TENANT.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate(mongoDbFactorySys, converter);
        return mongoTemplateSys;
    }

    @Bean("presetMongoTemplate")
    public MongoTemplate presetMongoTemplate(){
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, "preset");
        MongoTemplate presetMongoTemplate = new MongoTemplate(mongoDbFactory, converter);
        return presetMongoTemplate;
    }



}
